/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.events;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnItemFished;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Event;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.events.base.Priority;
import com.majruszlibrary.events.type.IEntityEvent;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1536;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class OnFishingExtraItemsGet
implements IEntityEvent {
    public final class_1657 player;
    public final class_1536 hook;
    public final class_1799 fishingRod;
    public final List<class_1799> items;
    public final List<class_1799> extraItems = new ArrayList<class_1799>();
    public int extraExperience = 0;

    public static Event<OnFishingExtraItemsGet> listen(Consumer<OnFishingExtraItemsGet> consumer) {
        return Events.get(OnFishingExtraItemsGet.class).add(consumer);
    }

    public OnFishingExtraItemsGet(OnItemFished data) {
        this.player = data.player;
        this.hook = data.hook;
        this.fishingRod = data.fishingRod;
        this.items = data.items;
    }

    @Override
    public class_1297 getEntity() {
        return this.player;
    }

    @AutoInstance
    public static class Increaser {
        public Increaser() {
            OnItemFished.listen(this::increaseLoot).priority(Priority.HIGHEST).addCondition(Condition.isLogicalServer());
        }

        private void increaseLoot(OnItemFished data) {
            OnFishingExtraItemsGet subdata = Events.dispatch(new OnFishingExtraItemsGet(data));
            if (!subdata.extraItems.isEmpty()) {
                this.spawnLoot(subdata);
                this.spawnExperience(subdata);
            }
        }

        private void spawnLoot(OnFishingExtraItemsGet data) {
            data.extraItems.forEach(itemStack -> {
                class_243 spawnPosition = AnyPos.from(data.hook.method_19538()).add(Random.nextVector(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25)).vec3();
                class_1542 itemEntity = new class_1542(data.getLevel(), spawnPosition.field_1352, spawnPosition.field_1351, spawnPosition.field_1350, itemStack);
                class_243 motion = data.player.method_19538().method_1020(itemEntity.method_19538()).method_18805(0.1, 0.1, 0.1);
                itemEntity.method_18799(motion.method_1031(0.0, Math.pow(AnyPos.from(motion).len().doubleValue(), 0.5) * 0.25, 0.0));
                data.getLevel().method_8649((class_1297)itemEntity);
            });
        }

        private void spawnExperience(OnFishingExtraItemsGet data) {
            if (data.extraExperience > 0) {
                EntityHelper.spawnExperience(data.getLevel(), AnyPos.from(data.player.method_19538()).add(0.5).vec3(), data.extraExperience);
            }
        }
    }
}

