/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.platform;

import com.majruszlibrary.platform.IIntegration;
import java.net.URL;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;

public class IntegrationFabric
implements IIntegration {
    @Override
    public boolean isLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    @Override
    public Optional<URL> getUpdateURL(String modId) {
        try {
            ModMetadata metadata;
            Optional mod = FabricLoader.getInstance().getModContainer(modId);
            if (mod.isPresent() && (metadata = ((ModContainer)mod.get()).getMetadata()).containsCustomValue("update")) {
                return Optional.of(new URL(metadata.getCustomValue("update").getAsString()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    @Override
    public String getName(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> mod.getMetadata().getName()).orElseThrow();
    }

    @Override
    public String getVersion(String modId) {
        return FabricLoader.getInstance().getModContainer(modId).map(mod -> mod.getMetadata().getVersion().getFriendlyString()).orElseThrow();
    }
}

