/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.handrails;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.foundation.block.render.SpriteShiftEntry;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import rbasamoyai.escalated.handrails.AbstractHandrailBlock;
import rbasamoyai.escalated.handrails.HandrailBlockEntity;
import rbasamoyai.escalated.index.EscalatedBlockPartials;
import rbasamoyai.escalated.index.EscalatedSpriteShiftEntries;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class HandrailRenderer
extends SafeBlockEntityRenderer<HandrailBlockEntity> {
    public HandrailRenderer(class_5614.class_5615 context) {
    }

    protected void renderSafe(HandrailBlockEntity be, float partialTicks, class_4587 ms, class_4597 bufferSource, int light, int overlay) {
        if (Backend.canUseInstancing((class_1937)be.method_10997())) {
            return;
        }
        class_2680 state = be.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof AbstractHandrailBlock)) {
            return;
        }
        AbstractHandrailBlock handrailBlock = (AbstractHandrailBlock)class_22482;
        class_4588 vcons = bufferSource.getBuffer(class_1921.method_23577());
        WalkwaySlope slope = handrailBlock.getHandrailSlope(state);
        boolean end = handrailBlock.isEndHandrail(state);
        AbstractHandrailBlock.Side side = (AbstractHandrailBlock.Side)((Object)state.method_11654(AbstractHandrailBlock.SIDE));
        class_2350 facing = (class_2350)state.method_11654((class_2769)AbstractHandrailBlock.field_11177);
        class_1767 handrailColor = be.getHandrailColor();
        PartialModel model = HandrailRenderer.getHandrailModel(slope, end);
        SuperByteBuffer buf = CachedBufferer.partialFacing((PartialModel)model, (class_2680)state, (class_2350)facing.method_10153());
        SpriteShiftEntry spriteShift = HandrailRenderer.getSpriteShift(handrailColor);
        float scroll = HandrailRenderer.getScrollOffset(be, partialTicks, facing, spriteShift.getTarget().method_4593(), spriteShift.getTarget().method_4575());
        if (side == AbstractHandrailBlock.Side.LEFT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.method_22903();
            class_2350 left = facing.method_10160();
            ms.method_46416((float)(left.method_10148() * 7) / 16.0f, 0.0f, (float)(left.method_10165() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.method_22909();
        }
        if (side == AbstractHandrailBlock.Side.RIGHT || side == AbstractHandrailBlock.Side.BOTH) {
            ms.method_22903();
            class_2350 right = facing.method_10170();
            ms.method_46416((float)(right.method_10148() * 7) / 16.0f, 0.0f, (float)(right.method_10165() * 7) / 16.0f);
            buf.light(light).shiftUVScrolling(spriteShift, scroll).renderInto(ms, vcons);
            ms.method_22909();
        }
    }

    public static PartialModel getHandrailModel(WalkwaySlope slope, boolean end) {
        return switch (slope) {
            default -> throw new IncompatibleClassChangeError();
            case WalkwaySlope.HORIZONTAL -> EscalatedBlockPartials.HANDRAIL_HORIZONTAL;
            case WalkwaySlope.BOTTOM -> EscalatedBlockPartials.HANDRAIL_BOTTOM;
            case WalkwaySlope.MIDDLE -> EscalatedBlockPartials.HANDRAIL_MIDDLE;
            case WalkwaySlope.TOP -> EscalatedBlockPartials.HANDRAIL_TOP;
            case WalkwaySlope.TERMINAL -> end ? EscalatedBlockPartials.HANDRAIL_END : EscalatedBlockPartials.HANDRAIL_START;
        };
    }

    public static SpriteShiftEntry getSpriteShift(@Nullable class_1767 color) {
        return color == null ? EscalatedSpriteShiftEntries.HANDRAIL : EscalatedSpriteShiftEntries.DYED_HANDRAILS.getOrDefault(color, EscalatedSpriteShiftEntries.HANDRAIL);
    }

    public static float getScrollOffset(HandrailBlockEntity be, float partialTicks, class_2350 facing, float v0, float v1) {
        float speed = be.getSpeed();
        float stepOffset = be.getVisualProgress() + partialTicks * speed;
        if (facing == class_2350.field_11043 || facing == class_2350.field_11034) {
            stepOffset *= -1.0f;
        }
        return (v1 - v0) * (stepOffset += 1.0f) / 3.0f;
    }
}

