/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.capabilities;

import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemHandler;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class DrawerItemHandler
implements IItemHandler {
    private final IDrawerGroup group;

    public DrawerItemHandler(IDrawerGroup group) {
        this.group = group;
    }

    @Override
    public int getSlots() {
        if (!this.group.isGroupValid() || this.isSuspended()) {
            return 0;
        }
        return this.group.getDrawerCount() + 1;
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid() || this.isSuspended()) {
            return class_1799.field_8037;
        }
        if (this.slotIsVirtual(slot)) {
            return class_1799.field_8037;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty() || drawer.getAttributes().isSuspended()) {
            return class_1799.field_8037;
        }
        class_1799 stack = drawer.getStoredItemPrototype().method_7972();
        stack.method_7939(drawer.getStoredItemCount());
        return stack;
    }

    @Override
    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        IDrawer prevDrawer;
        IDrawer drawer;
        int prevSlot;
        if (!this.group.isGroupValid() || this.isSuspended()) {
            return stack;
        }
        if (this.slotIsVirtual(slot)) {
            return this.insertItemFullScan(stack, simulate);
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        int orderedSlot = --slot >= 0 && slot < order.length ? order[slot] : -1;
        int n = prevSlot = slot >= 1 && slot < order.length ? order[slot - 1] : -1;
        if (orderedSlot > 0 && (drawer = this.group.getDrawer(orderedSlot)).isEnabled() && drawer.isEmpty() && (!(prevDrawer = this.group.getDrawer(prevSlot)).isEnabled() || !prevDrawer.isEmpty())) {
            return this.insertItemFullScan(stack, simulate);
        }
        return this.insertItemInternal(orderedSlot, stack, simulate);
    }

    @NotNull
    private class_1799 insertItemFullScan(@NotNull class_1799 stack, boolean simulate) {
        IItemRepository itemRepo = this.group.getCapability(Capabilities.ITEM_REPOSITORY);
        if (itemRepo != null) {
            return itemRepo.insertItem(stack, simulate);
        }
        for (int i = 0; i < this.group.getDrawerCount() && !(stack = this.insertItemInternal(i, stack, simulate)).method_7960(); ++i) {
        }
        return stack;
    }

    @NotNull
    private class_1799 insertItemInternal(int slot, @NotNull class_1799 stack, boolean simulate) {
        int remainder;
        IDrawer drawer = this.group.getDrawer(slot);
        if (drawer.getAttributes().isSuspended() || !drawer.canItemBeStored(stack)) {
            return stack;
        }
        if (drawer.isEmpty() && !simulate) {
            drawer = drawer.setStoredItem(stack);
        }
        boolean empty = drawer.isEmpty();
        int n = simulate ? Math.max(stack.method_7947() - (empty ? drawer.getAcceptingMaxCapacity(stack) : drawer.getAcceptingRemainingCapacity()), 0) : (remainder = drawer.adjustStoredItemCount(stack.method_7947()));
        if (remainder == stack.method_7947()) {
            return stack;
        }
        if (remainder == 0) {
            return class_1799.field_8037;
        }
        return this.stackResult(stack, remainder);
    }

    @Override
    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        IDrawer drawer;
        if (!this.group.isGroupValid() || this.isSuspended()) {
            return class_1799.field_8037;
        }
        if (this.slotIsVirtual(slot)) {
            return class_1799.field_8037;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.isEmpty() || drawer.getAttributes().isSuspended() || drawer.getStoredItemCount() == 0) {
            return class_1799.field_8037;
        }
        @NotNull class_1799 prototype = drawer.getStoredItemPrototype();
        int remaining = simulate ? Math.max(amount - drawer.getStoredItemCount(), 0) : drawer.adjustStoredItemCount(-amount);
        return this.stackResult(prototype, amount - remaining);
    }

    @Override
    public int getSlotLimit(int slot) {
        IDrawer drawer;
        if (!this.group.isGroupValid() || this.isSuspended()) {
            return 0;
        }
        if (this.slotIsVirtual(slot)) {
            return Integer.MAX_VALUE;
        }
        int[] order = this.group.getAccessibleDrawerSlots();
        if (!(drawer = this.group.getDrawer(slot = --slot >= 0 && slot < order.length ? order[slot] : -1)).isEnabled() || drawer.getAttributes().isSuspended()) {
            return 0;
        }
        if (drawer.isEmpty()) {
            return drawer.getMaxCapacity(class_1799.field_8037);
        }
        return drawer.getMaxCapacity();
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return true;
    }

    protected boolean isSuspended() {
        IDrawerAttributes attrs = this.group.getCapability(Capabilities.DRAWER_ATTRIBUTES);
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        return attrs.isSuspended();
    }

    private boolean slotIsVirtual(int slot) {
        return slot == 0;
    }

    private class_1799 stackResult(@NotNull class_1799 stack, int amount) {
        class_1799 result = stack.method_7972();
        result.method_7939(amount);
        return result;
    }
}

