/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.storage;

import com.jaquadro.minecraft.storagedrawers.api.storage.IControlGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityController;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.util.ItemStackMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class StorageUtil {
    public static void rebalanceDrawers(IDrawerGroup group, int slot) {
        StorageUtil.rebalanceDrawers(group, slot, null);
    }

    public static void rebalanceDrawers(IDrawerGroup group, int slot, class_1657 player) {
        IDrawer drawer = group.getDrawer(slot);
        if (drawer.isEnabled()) {
            StorageUtil.rebalanceDrawers(group, drawer.getStoredItemPrototype(), player);
        }
    }

    public static void rebalanceDrawers(IDrawerGroup group, class_1799 stack) {
        StorageUtil.rebalanceDrawers(group, stack, null);
    }

    public static void rebalanceDrawers(IDrawerGroup group, class_1799 stack, class_1657 player) {
        if (stack.method_7960()) {
            return;
        }
        if (group instanceof INetworked) {
            INetworked networked = (INetworked)((Object)group);
            if (StorageUtil.onNetwork(group)) {
                StorageUtil.rebalanceDrawers(StorageUtil.getRebalanceDrawers(networked, stack, player));
                return;
            }
        }
        ArrayList<IDrawer> drawers = new ArrayList<IDrawer>();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled() || !ItemStackMatcher.areItemsEqual(drawer.getStoredItemPrototype(), stack)) continue;
            drawers.add(drawer);
        }
        StorageUtil.rebalanceDrawers(drawers.stream());
    }

    private static boolean onNetwork(IDrawerGroup group) {
        if (!(group instanceof INetworked)) {
            return false;
        }
        INetworked node = (INetworked)((Object)group);
        IControlGroup bind = node.getBoundControlGroup();
        if (bind != null) {
            return true;
        }
        return !node.getSoftBoundControlGroups().isEmpty();
    }

    private static Stream<IDrawer> getRebalanceDrawers(INetworked node, class_1799 stack, class_1657 player) {
        Set<IControlGroup> controllers = node.getSoftBoundControlGroups();
        if (controllers.isEmpty()) {
            return Stream.empty();
        }
        if (controllers.size() == 1) {
            for (IControlGroup cg2 : controllers) {
                if (!(cg2 instanceof BlockEntityController)) continue;
                BlockEntityController controller = (BlockEntityController)cg2;
                return controller.getBalanceDrawers(stack, player);
            }
            return Stream.empty();
        }
        return controllers.stream().flatMap(cg -> {
            if (cg instanceof BlockEntityController) {
                BlockEntityController controller = (BlockEntityController)cg;
                return controller.getBalanceDrawers(stack, player);
            }
            return Stream.empty();
        });
    }

    public static void rebalanceDrawers(Stream<IDrawer> drawers, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        StorageUtil.rebalanceDrawers(drawers.filter(d -> ItemStackMatcher.areItemsEqual(d.getStoredItemPrototype(), stack)));
    }

    public static void rebalanceDrawers(Stream<IDrawer> drawers) {
        if (!((Boolean)ModCommonConfig.INSTANCE.UPGRADES.balanceUpgrade.enableUpgrade.get()).booleanValue()) {
            return;
        }
        List<IDrawer> balanceDrawers = drawers.filter(IDrawer::isEnabled).toList();
        if (balanceDrawers.size() <= 1) {
            return;
        }
        int aggCount = balanceDrawers.stream().mapToInt(IDrawer::getStoredItemCount).sum();
        List<Integer> balanceCapacity = balanceDrawers.stream().map(IDrawer::getMaxCapacity).toList();
        int[] newAmount = new int[balanceCapacity.size()];
        while (aggCount > 0) {
            int availDrawers = 0;
            for (int i = 0; i < balanceCapacity.size(); ++i) {
                if (newAmount[i] >= balanceCapacity.get(i)) continue;
                ++availDrawers;
            }
            int dist = aggCount / availDrawers;
            int remainder = aggCount - dist * availDrawers;
            int i = 0;
            while (i < balanceDrawers.size()) {
                int remaining = balanceCapacity.get(i) - newAmount[i];
                int toAdd = Math.min(remaining, dist + (i < remainder ? 1 : 0));
                int n = i++;
                newAmount[n] = newAmount[n] + toAdd;
                aggCount -= toAdd;
            }
        }
        for (int i = 0; i < balanceDrawers.size(); ++i) {
            balanceDrawers.get(i).setStoredItemCount(newAmount[i]);
        }
    }
}

