/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.sound;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.sound.SoundScape;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_3417;

public class SoundScapes {
    static final int MAX_AMBIENT_SOURCE_DISTANCE = 16;
    static final int UPDATE_INTERVAL = 5;
    static final int SOUND_VOLUME_ARG_MAX = 15;
    private static Map<AmbienceGroup, Map<PitchGroup, Set<class_2338>>> counter = new IdentityHashMap<AmbienceGroup, Map<PitchGroup, Set<class_2338>>>();
    private static Map<Pair<AmbienceGroup, PitchGroup>, SoundScape> activeSounds = new HashMap<Pair<AmbienceGroup, PitchGroup>, SoundScape>();

    private static SoundScape kinetic(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).continuous(class_3417.field_14832, 0.25f, 1.0f);
    }

    private static SoundScape cogwheel(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).continuous(AllSoundEvents.COGS.getMainEvent(), 1.5f, 1.0f);
    }

    private static SoundScape crushing(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).repeating(AllSoundEvents.CRUSHING_1.getMainEvent(), 1.545f, 0.75f, 1).repeating(AllSoundEvents.CRUSHING_2.getMainEvent(), 0.425f, 0.75f, 2).repeating(AllSoundEvents.CRUSHING_3.getMainEvent(), 2.0f, 1.75f, 2);
    }

    private static SoundScape milling(float pitch, AmbienceGroup group) {
        return new SoundScape(pitch, group).repeating(AllSoundEvents.CRUSHING_1.getMainEvent(), 1.545f, 0.75f, 1).repeating(AllSoundEvents.CRUSHING_2.getMainEvent(), 0.425f, 0.75f, 2);
    }

    public static void play(AmbienceGroup group, class_2338 pos, float pitch) {
        if (!((Boolean)AllConfigs.client().enableAmbientSounds.get()).booleanValue()) {
            return;
        }
        if (!SoundScapes.outOfRange(pos)) {
            SoundScapes.addSound(group, pos, pitch);
        }
    }

    public static void tick() {
        activeSounds.values().forEach(SoundScape::tick);
        if (AnimationTickHolder.getTicks() % 5 != 0) {
            return;
        }
        boolean disable = (Boolean)AllConfigs.client().enableAmbientSounds.get() == false;
        Iterator<Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape>> iterator = activeSounds.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Pair<AmbienceGroup, PitchGroup>, SoundScape> entry = iterator.next();
            Pair<AmbienceGroup, PitchGroup> key = entry.getKey();
            SoundScape value = entry.getValue();
            if (!disable && SoundScapes.getSoundCount(key.getFirst(), key.getSecond()) != 0) continue;
            value.remove();
            iterator.remove();
        }
        counter.values().forEach(m -> m.values().forEach(Set::clear));
    }

    private static void addSound(AmbienceGroup group, class_2338 pos, float pitch) {
        PitchGroup groupFromPitch = SoundScapes.getGroupFromPitch(pitch);
        Set set = counter.computeIfAbsent(group, ag -> new IdentityHashMap()).computeIfAbsent(groupFromPitch, pg -> new HashSet());
        set.add(pos);
        Pair<AmbienceGroup, PitchGroup> pair = Pair.of(group, groupFromPitch);
        activeSounds.computeIfAbsent(pair, $ -> {
            SoundScape soundScape = group.instantiate(pitch);
            soundScape.play();
            return soundScape;
        });
    }

    public static void invalidateAll() {
        counter.clear();
        activeSounds.forEach(($, sound) -> sound.remove());
        activeSounds.clear();
    }

    protected static boolean outOfRange(class_2338 pos) {
        return !SoundScapes.getCameraPos().method_19771((class_2382)pos, 16.0);
    }

    protected static class_2338 getCameraPos() {
        class_1297 renderViewEntity = class_310.method_1551().field_1719;
        if (renderViewEntity == null) {
            return class_2338.field_10980;
        }
        class_2338 playerLocation = renderViewEntity.method_24515();
        return playerLocation;
    }

    public static int getSoundCount(AmbienceGroup group, PitchGroup pitchGroup) {
        return SoundScapes.getAllLocations(group, pitchGroup).size();
    }

    public static Set<class_2338> getAllLocations(AmbienceGroup group, PitchGroup pitchGroup) {
        return counter.getOrDefault((Object)group, Collections.emptyMap()).getOrDefault((Object)pitchGroup, Collections.emptySet());
    }

    public static PitchGroup getGroupFromPitch(float pitch) {
        if ((double)pitch < 0.7) {
            return PitchGroup.VERY_LOW;
        }
        if ((double)pitch < 0.9) {
            return PitchGroup.LOW;
        }
        if ((double)pitch < 1.1) {
            return PitchGroup.NORMAL;
        }
        if ((double)pitch < 1.3) {
            return PitchGroup.HIGH;
        }
        return PitchGroup.VERY_HIGH;
    }

    public static enum AmbienceGroup {
        KINETIC(SoundScapes::kinetic),
        COG(SoundScapes::cogwheel),
        CRUSHING(SoundScapes::crushing),
        MILLING(SoundScapes::milling);

        private BiFunction<Float, AmbienceGroup, SoundScape> factory;

        private AmbienceGroup(BiFunction<Float, AmbienceGroup, SoundScape> factory) {
            this.factory = factory;
        }

        public SoundScape instantiate(float pitch) {
            return this.factory.apply(Float.valueOf(pitch), this);
        }
    }

    static enum PitchGroup {
        VERY_LOW,
        LOW,
        NORMAL,
        HIGH,
        VERY_HIGH;

    }
}

