/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.debugInfo.element;

import com.simibubi.create.infrastructure.debugInfo.DebugInformation;
import com.simibubi.create.infrastructure.debugInfo.InfoProvider;
import com.simibubi.create.infrastructure.debugInfo.element.InfoElement;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public record InfoEntry(String name, InfoProvider provider) implements InfoElement
{
    public InfoEntry(String name, String info) {
        this(name, (class_1657 player) -> info);
    }

    @Override
    public void write(class_1657 player, class_2540 buffer) {
        buffer.writeBoolean(false);
        buffer.method_10814(this.name);
        buffer.method_10814(this.provider.getInfoSafe(player));
    }

    @Override
    public void print(int depth, @Nullable class_1657 player, Consumer<String> lineConsumer) {
        String value = this.provider.getInfoSafe(player);
        String indent = DebugInformation.getIndent(depth);
        if (value.contains("\n")) {
            String[] lines = value.split("\n");
            String firstLine = lines[0];
            String lineStart = this.name + ": ";
            lineConsumer.accept(indent + lineStart + firstLine);
            String extraIndent = Stream.generate(() -> " ").limit(lineStart.length()).collect(Collectors.joining());
            for (int i = 1; i < lines.length; ++i) {
                lineConsumer.accept(indent + extraIndent + lines[i]);
            }
        } else {
            lineConsumer.accept(indent + this.name + ": " + value);
        }
    }

    public static InfoEntry read(class_2540 buffer) {
        String name = buffer.method_19772();
        String value = buffer.method_19772();
        return new InfoEntry(name, value);
    }
}

