/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.common;

import com.majruszlibrary.events.OnLootGenerated;
import com.majruszlibrary.level.LevelHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.text.TextHelper;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.BonusHandler;
import com.majruszsaccessories.tooltip.ITooltipProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5250;

public class BonusComponent<Type extends class_1792> {
    protected final BonusHandler<Type> handler;
    final List<ITooltipProvider> tooltipProviders = new ArrayList<ITooltipProvider>();

    public BonusComponent(BonusHandler<Type> handler) {
        this.handler = handler;
    }

    public BonusComponent<Type> addTooltip(final String key, final ITooltipProvider ... providers) {
        this.tooltipProviders.add(new ITooltipProvider(){

            @Override
            public class_5250 getTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getTooltip(holder)).toArray());
            }

            @Override
            public class_5250 getDetailedTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getDetailedTooltip(holder)).toArray());
            }

            @Override
            public class_5250 getRangeTooltip(AccessoryHolder holder) {
                return TextHelper.translatable((String)key, (Object[])Stream.of(providers).map(provider -> provider.getRangeTooltip(holder)).toArray());
            }
        });
        return this;
    }

    public List<ITooltipProvider> getTooltipProviders() {
        return Collections.unmodifiableList(this.tooltipProviders);
    }

    protected void addToGeneratedLoot(OnLootGenerated data) {
        data.generatedLoot.add((Object)this.constructItemStack());
    }

    protected void replaceGeneratedLoot(OnLootGenerated data) {
        data.generatedLoot.clear();
        data.generatedLoot.add((Object)this.constructItemStack());
    }

    protected void spawnFlyingItem(class_1937 level, class_243 from, class_243 to) {
        LevelHelper.spawnItemEntityFlyingTowardsDirection((class_1799)this.constructItemStack(), (class_1937)level, (class_243)from, (class_243)to);
    }

    protected void spawnFlyingItem(class_1937 level, class_243 position) {
        LevelHelper.spawnItemEntityFlyingTowardsDirection((class_1799)this.constructItemStack(), (class_1937)level, (class_243)position, (class_243)AnyPos.from((class_243)position).add((Number)0.0, (Number)1.0, (Number)0.0).vec3());
    }

    protected class_1799 constructItemStack() {
        AccessoryHolder holder = AccessoryHolder.create(this.handler.getItem());
        if (holder.isValid()) {
            holder.setRandomBonus();
        }
        return holder.getItemStack();
    }

    protected Type getItem() {
        return this.handler.getItem();
    }

    @FunctionalInterface
    public static interface ISupplier<Type extends class_1792> {
        public BonusComponent<Type> apply(BonusHandler<Type> var1);
    }
}

