/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsaccessories.listeners;

import com.majruszlibrary.annotation.AutoInstance;
import com.majruszlibrary.client.ClientHelper;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.events.base.Events;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsaccessories.MajruszsAccessories;
import com.majruszsaccessories.common.AccessoryHolder;
import com.majruszsaccessories.common.AccessoryHolders;
import com.majruszsaccessories.events.OnAccessoryTooltip;
import com.majruszsaccessories.items.AccessoryItem;
import com.majruszsaccessories.tooltip.TooltipHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

@AutoInstance
public class AccessoryTooltipUpdater {
    static final int PAGE_SIZE = 7;

    public AccessoryTooltipUpdater() {
        OnItemTooltip.listen(this::addTooltip).addCondition(Condition.predicate(data -> data.itemStack.method_7909() instanceof AccessoryItem));
    }

    private void addTooltip(OnItemTooltip data) {
        AccessoryHolder holder = Optional.ofNullable(data.player).map(player -> AccessoryHolders.find((class_1309)player).get().stream().filter(subholder -> subholder.getItemStack() == data.itemStack).findFirst()).flatMap(subholder -> subholder).orElse(AccessoryHolder.create(data.itemStack));
        if (holder.hasBonusRangeDefined() && !holder.hasBonusDefined()) {
            data.components.addAll(this.buildBonusRangeInfo(holder));
        } else {
            data.components.addAll(this.buildBonusInfo(holder));
        }
        data.components.addAll(this.buildUseInfo(holder, data.player));
        data.components.addAll(this.buildEffectsInfo(holder));
    }

    private List<class_2561> buildBonusRangeInfo(AccessoryHolder holder) {
        Range<Float> range = holder.getClampedBonusRange();
        class_5250 min = TextHelper.literal((String)TextHelper.signedPercent((float)((Float)range.from).floatValue())).method_27692(AccessoryHolder.getBonusFormatting(((Float)range.from).floatValue()));
        class_5250 max = TextHelper.literal((String)TextHelper.signedPercent((float)((Float)range.to).floatValue())).method_27692(AccessoryHolder.getBonusFormatting(((Float)range.to).floatValue()));
        return List.of(TextHelper.translatable((String)"majruszsaccessories.items.bonus", (Object[])new Object[]{TooltipHelper.asRange(min, max)}).method_27692(class_124.field_1080));
    }

    private List<class_2561> buildBonusInfo(AccessoryHolder holder) {
        float baseBonus = holder.getBaseBonus();
        float bonus = holder.getBonus();
        if (baseBonus == 0.0f && bonus == 0.0f) {
            return List.of();
        }
        class_5250 component = ClientHelper.isShiftDown() && holder.getExtraBonus() != 0.0f ? TooltipHelper.asFormula(TextHelper.literal((String)TextHelper.signedPercent((float)baseBonus)).method_27692(AccessoryHolder.getBonusFormatting(baseBonus)), TextHelper.literal((String)TextHelper.signedPercent((float)holder.getExtraBonus())).method_27692(AccessoryHolder.getBonusFormatting(bonus))) : TextHelper.literal((String)TextHelper.signedPercent((float)bonus));
        return List.of(TextHelper.translatable((String)"majruszsaccessories.items.bonus", (Object[])new Object[]{component}).method_27692(holder.getBonusFormatting()));
    }

    private List<class_2561> buildUseInfo(AccessoryHolder holder, @Nullable class_1657 player) {
        if (MajruszsAccessories.SLOT_INTEGRATION.isInstalled()) {
            return List.of();
        }
        return List.of(TextHelper.translatable((String)"majruszsaccessories.items.accessory_item", (Object[])new Object[0]).method_27692(this.getUseFormatting(holder, player)));
    }

    private class_124 getUseFormatting(AccessoryHolder holder, @Nullable class_1657 player) {
        if (player != null) {
            if (AccessoryHolders.get((class_1309)player).get(holder::getItem) == holder) {
                return class_124.field_1065;
            }
        }
        return class_124.field_1063;
    }

    private List<class_2561> buildEffectsInfo(AccessoryHolder holder) {
        boolean cannotFitSinglePage;
        OnAccessoryTooltip tooltipData = (OnAccessoryTooltip)Events.dispatch((Object)new OnAccessoryTooltip(holder));
        boolean bl = cannotFitSinglePage = tooltipData.components.size() > 7;
        if (cannotFitSinglePage) {
            return this.getCurrentPageSublist(tooltipData.components);
        }
        return tooltipData.components;
    }

    private List<class_2561> getCurrentPageSublist(List<class_2561> components) {
        int totalPages = (int)Math.ceil((double)components.size() / 7.0);
        int currentPage = (int)(Math.floor((double)TimeHelper.getTicks() / (double)TimeHelper.toTicks((double)14.0)) % (double)totalPages);
        ArrayList<class_2561> pageComponents = new ArrayList<class_2561>(components.subList(currentPage * 7, Math.min((currentPage + 1) * 7, components.size())));
        pageComponents.add((class_2561)TextHelper.translatable((String)"majruszsaccessories.items.page", (Object[])new Object[]{currentPage + 1, totalPages}).method_27692(class_124.field_1063));
        return pageComponents;
    }

    static final class Tooltips {
        static final String INVENTORY = "majruszsaccessories.items.accessory_item";
        static final String BONUS = "majruszsaccessories.items.bonus";
        static final String PAGE = "majruszsaccessories.items.page";

        Tooltips() {
        }
    }
}

