/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import java.util.List;
import net.mehvahdjukaar.amendments.common.LiquidMixer;
import net.mehvahdjukaar.amendments.common.block.DyeCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.LiquidCauldronBlock;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.item.DyeBottleItem;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlockTile
extends class_2586
implements IExtraModelDataProvider,
ISoftFluidTankProvider {
    public static final ModelDataKey<class_5321<SoftFluid>> FLUID = new ModelDataKey(class_5321.class);
    public static final ModelDataKey<Boolean> GLOWING = new ModelDataKey(Boolean.class);
    private final SoftFluidTank fluidTank;
    private boolean hasGlowInk = false;

    public SoftFluidTank makeTank(class_2680 blockState) {
        return blockState.method_26204() instanceof DyeCauldronBlock ? this.createCauldronDyeTank() : this.createCauldronLiquidTank();
    }

    private boolean canMixPotions() {
        CommonConfigs.MixingMode config = CommonConfigs.POTION_MIXING.get();
        return config == CommonConfigs.MixingMode.ON || config == CommonConfigs.MixingMode.ONLY_BOILING && (Boolean)this.method_11010().method_11654((class_2769)LiquidCauldronBlock.BOILING) != false;
    }

    public LiquidCauldronBlockTile(class_2338 blockPos, class_2680 blockState) {
        super(ModRegistry.LIQUID_CAULDRON_TILE.get(), blockPos, blockState);
        this.fluidTank = this.makeTank(blockState);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        builder.with(FLUID, (Object)((class_5321)this.fluidTank.getFluid().getHolder().method_40230().get()));
        builder.with(GLOWING, (Object)this.hasGlowInk);
    }

    public SoftFluidTank getSoftFluidTank() {
        return this.fluidTank;
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.fluidTank.load(compound);
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.fluidTank.refreshTintCache();
            this.requestModelReload();
        }
        this.hasGlowInk = compound.method_10577("glow_ink");
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.fluidTank.save(tag);
        if (this.hasGlowInk) {
            tag.method_10556("glow_ink", true);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    public void method_5431() {
        if (this.field_11863 == null) {
            return;
        }
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof ModCauldronBlock) {
            ModCauldronBlock cb = (ModCauldronBlock)class_22482;
            state = cb.updateStateOnFluidChange(state, this.field_11863, this.field_11867, this.fluidTank.getFluid());
        }
        if (state != this.method_11010()) {
            this.field_11863.method_8501(this.field_11867, state);
        }
        this.field_11863.method_8413(this.field_11867, this.method_11010(), state, 2);
        super.method_5431();
    }

    public boolean handleInteraction(class_1657 player, class_1268 hand) {
        if (this.fluidTank.interactWithPlayer(player, hand, this.field_11863, this.field_11867)) {
            this.field_11863.method_33596((class_1297)player, class_5712.field_28733, this.field_11867);
            this.method_5431();
            this.maybeSendPotionMixMessage(this.getSoftFluidTank(), player);
            return true;
        }
        return false;
    }

    public void consumeOneLayer() {
        this.fluidTank.getFluid().shrink(1);
        this.method_5431();
    }

    public void maybeSendPotionMixMessage(SoftFluidTank fluidTank, class_1657 player) {
        List potionEffects;
        int potionEffectAmount;
        if (fluidTank.getFluid().is((class_6880)BuiltInSoftFluids.POTION) && (potionEffectAmount = (potionEffects = class_1844.method_8066((class_2487)fluidTank.getFluid().getTag())).size()) == CommonConfigs.POTION_MIXING_LIMIT.get()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.amendments.cauldron"), true);
        }
    }

    public SoftFluidTank createCauldronLiquidTank() {
        return new SoftFluidTank(PlatHelper.getPlatform().isFabric() ? 3 : 4){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is((class_6880)BuiltInSoftFluids.WATER)) {
                    return false;
                }
                if (LiquidCauldronBlockTile.this.canMixPotions() && fluidStack.is((class_6880)BuiltInSoftFluids.POTION) && fluidStack.is(this.fluidStack.getHolder())) {
                    return this.fluidStack.getTag().method_10558("Bottle").equals(fluidStack.getTag().method_10558("Bottle"));
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack incoming) {
                if (LiquidCauldronBlockTile.this.canMixPotions() && incoming.is((class_6880)BuiltInSoftFluids.POTION)) {
                    LiquidMixer.mixPotions(this.fluidStack, incoming);
                    this.needsColorRefresh = true;
                }
                super.addFluidOntoExisting(incoming);
            }
        };
    }

    public SoftFluidTank createCauldronDyeTank() {
        return new SoftFluidTank(3){

            public boolean isFluidCompatible(SoftFluidStack fluidStack) {
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID) && fluidStack.is(this.fluidStack.getHolder())) {
                    return true;
                }
                return super.isFluidCompatible(fluidStack);
            }

            protected void addFluidOntoExisting(SoftFluidStack fluidStack) {
                if (fluidStack.is(ModRegistry.DYE_SOFT_FLUID)) {
                    LiquidMixer.mixDye(this.fluidStack, fluidStack);
                }
                super.addFluidOntoExisting(fluidStack);
            }

            @Nullable
            public class_1799 interactWithItem(class_1799 stack, class_1937 world, @Nullable class_2338 pos, boolean simulate) {
                class_1792 class_17922 = stack.method_7909();
                if (class_17922 instanceof class_1769) {
                    class_1769 di = (class_1769)class_17922;
                    if (!simulate) {
                        this.addDye(di, world, pos);
                    }
                    return class_1799.field_8037;
                }
                return super.interactWithItem(stack, world, pos, simulate);
            }

            private void addDye(class_1769 dyeItem, class_1937 world, @Nullable class_2338 pos) {
                SoftFluidStack fluid = this.getFluid();
                if (!world.method_8608()) {
                    int count = fluid.getCount();
                    if (count == 3) {
                        fluid.setCount(2);
                    }
                    SoftFluidStack dummyStack = DyeBottleItem.toFluidStack(dyeItem.method_7802(), 1);
                    LiquidMixer.mixDye(fluid, dummyStack);
                    fluid.setCount(count);
                }
                if (pos != null) {
                    world.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_8396(null, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.3f);
                }
            }
        };
    }

    public boolean isGlowing() {
        return this.hasGlowInk;
    }

    public void setGlowing(boolean b) {
        this.hasGlowInk = b;
        this.method_5431();
    }
}

