/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.config;

import com.simibubi.create.foundation.config.ConfigBase;
import java.util.Objects;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.index.Config;

public class CreateCobblestoneCommon
extends ConfigBase {
    public final ConfigBase.ConfigGroup common = this.group(0, "common", new String[]{Comments.common});
    public final ConfigBase.ConfigInt generatorStress = this.i(8, 0, "generatorStress", Comments.generatorStress);
    public final ConfigBase.ConfigFloat outputPerSecondPerRpm = this.f(2.5f, 0.0f, "outputPerSecondPerRpm", Comments.outputPerSecondPerRpm);
    public final ConfigBase.ConfigInt maxStorage = this.i(256, 1, "maxGeneratorStorage", Comments.maxStorage);
    public final ConfigBase.ConfigBool enableDebugLogging = this.b(false, "enableDebugLogging", Comments.enableDebugLogging);
    public final ConfigBase.ConfigGroup generatorsGroup = this.group(1, "generatorsEnabled", Comments.generatorsGroup);
    public final ConfigBase.ConfigBool cobblestoneGeneratorEnabled = this.b(true, "cobblestoneGeneratorEnabled", new String[]{Comments.generatorEnabled});
    public final ConfigBase.ConfigBool basaltGeneratorEnabled = this.b(true, "basaltGeneratorEnabled", new String[]{Comments.generatorEnabled});
    public final ConfigBase.ConfigBool stoneGeneratorEnabled = this.b(true, "stoneGeneratorEnabled", new String[]{Comments.generatorEnabled});
    public final ConfigBase.ConfigBool limestoneGeneratorEnabled = this.b(true, "limestoneGeneratorEnabled", new String[]{Comments.generatorEnabled});
    public final ConfigBase.ConfigBool scoriaGeneratorEnabled = this.b(true, "scoriaGeneratorEnabled", new String[]{Comments.generatorEnabled});
    public final ConfigBase.ConfigBool deepslateGeneratorEnabled = this.b(true, "deepslateGeneratorEnabled", Comments.deepslateGeneratorsEnabled);
    public final ConfigBase.ConfigBool cobbledDeepslateGeneratorEnabled = this.b(true, "cobbledDeepslateGeneratorEnabled", Comments.deepslateGeneratorsEnabled);

    public String getName() {
        return "common";
    }

    public boolean isEnabled(GeneratorType type) {
        if (type.equals(GeneratorType.NONE)) {
            return true;
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/cobblestone.json")) {
            return (Boolean)Config.common().cobblestoneGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/stone.json")) {
            return (Boolean)Config.common().stoneGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/basalt.json")) {
            return (Boolean)Config.common().basaltGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/limestone.json")) {
            return (Boolean)Config.common().limestoneGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/scoria.json")) {
            return (Boolean)Config.common().scoriaGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/deepslate.json")) {
            return (Boolean)Config.common().deepslateGeneratorEnabled.get();
        }
        if (Objects.equals(type.getId(), "createcobblestone:generator_types/cobbled_deepslate.json")) {
            return (Boolean)Config.common().cobbledDeepslateGeneratorEnabled.get();
        }
        return true;
    }

    private static class Comments {
        public static String common = "Common config";
        public static String[] generatorStress = new String[]{"stress * rpm = total stress", "(Can be overridden by custom generator types)"};
        public static String[] outputPerSecondPerRpm = new String[]{"(Can be overridden by custom generator types)"};
        public static String[] maxStorage = new String[]{"(Can be overridden by custom generator types)"};
        public static String[] enableDebugLogging = new String[]{"Log information that may be usefull for reporting a problem and debugging it.", "THIS WILL SPAM YOUR LOGS"};
        public static String[] generatorsGroup = new String[]{"Cobblestone generator types"};
        public static String generatorEnabled = "Enables the generator. When disabled, the generator is replaced with unset generators. Make a backup before doing this.";
        public static String[] deepslateGeneratorsEnabled = new String[]{generatorEnabled, "(Also requires deepslate generators datapack, https://modrinth.com/datapack/create-cobblestone-deepslate-generators)"};

        private Comments() {
        }
    }
}

