/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.createcobblestone.CreateCobblestoneMod;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.data.fabric.GeneratorTypeLoaderImpl;
import net.createcobblestone.index.Network;
import net.minecraft.class_2246;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import oshi.util.tuples.Quintet;

public class GeneratorTypeLoader {
    public static boolean loaded = false;
    public static List<Quintet<String, String, Integer, Float, Integer>> loadedTypes = new ArrayList<Quintet<String, String, Integer, Float, Integer>>();

    public static void loadGeneratorTypes(class_3300 resourceManager) {
        loaded = false;
        GeneratorType.init();
        loadedTypes.clear();
        CreateCobblestoneMod.LOGGER.info("Loading generator types from datapacks");
        Map resources = resourceManager.method_14488("generator_types", location -> location.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 id = (class_2960)entry.getKey();
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream inputStream = resource.method_14482();
                try {
                    JsonObject generatorJsonData = JsonParser.parseString((String)new String(inputStream.readAllBytes())).getAsJsonObject();
                    String block = generatorJsonData.get("block").getAsString();
                    if (class_7923.field_41175.method_10223(new class_2960(block)) == class_2246.field_10124) {
                        CreateCobblestoneMod.LOGGER.error("Generator type {} has no block assigned", (Object)id);
                    }
                    int generatorStress = -1;
                    float outputPerSecondPerRpm = -1.0f;
                    int generatorStorage = -1;
                    if (generatorJsonData.has("enabled") && !generatorJsonData.get("enabled").getAsBoolean()) continue;
                    if (generatorJsonData.has("stress")) {
                        generatorStress = generatorJsonData.get("stress").getAsInt();
                    }
                    if (generatorJsonData.has("outputPerSecondPerRpm")) {
                        outputPerSecondPerRpm = generatorJsonData.get("outputPerSecondPerRpm").getAsFloat();
                    }
                    if (generatorJsonData.has("storage")) {
                        generatorStorage = generatorJsonData.get("storage").getAsInt();
                    }
                    if (generatorJsonData.has("ratio")) {
                        if (generatorJsonData.has("outputPerSecondPerRpm")) {
                            CreateCobblestoneMod.LOGGER.error("Generator type {} has both ratio and outputPerSecondPerRpm, outputPerSecondPerRpm will be used", (Object)id);
                        } else {
                            CreateCobblestoneMod.LOGGER.warn("Generator type {} has deprecated ratio, please use outputPerSecondPerRpm instead. (Converted to {} outputPerSecondPerRpm)", (Object)id, (Object)Float.valueOf(1.0f / generatorJsonData.get("ratio").getAsFloat() * 20.0f));
                            outputPerSecondPerRpm = 1.0f / generatorJsonData.get("ratio").getAsFloat() * 20.0f;
                        }
                    }
                    loadedTypes.add((Quintet<String, String, Integer, Float, Integer>)new Quintet((Object)id.toString(), (Object)block, (Object)generatorStress, (Object)Float.valueOf(outputPerSecondPerRpm), (Object)generatorStorage));
                    GeneratorType.initializeNewType(id.toString(), new class_2960(block), generatorStress, outputPerSecondPerRpm, generatorStorage);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (Exception e) {
                CreateCobblestoneMod.LOGGER.error("Error loading generator type: " + String.valueOf(id), (Throwable)e);
            }
        }
        loaded = true;
        CreateCobblestoneMod.LOGGER.info("Generator types loading done");
    }

    public static void sendGeneratorTypesToClient(Iterable<class_3222> players) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(loadedTypes.size());
        for (Quintet<String, String, Integer, Float, Integer> type : loadedTypes) {
            buf.method_10814((String)type.getA());
            buf.method_10814((String)type.getB());
            buf.writeInt(((Integer)type.getC()).intValue());
            buf.writeFloat(((Float)type.getD()).floatValue());
            buf.writeInt(((Integer)type.getE()).intValue());
        }
        NetworkManager.sendToPlayers(players, (class_2960)Network.GENERATOR_TYPES_PACKET, (class_2540)buf);
        CreateCobblestoneMod.LOGGER.info("Send generator update packet to client");
    }

    public static void loadGeneratorTypesFromPacket(class_2540 buf, NetworkManager.PacketContext context) {
        CreateCobblestoneMod.LOGGER.info("Received generator update packet");
        loaded = false;
        GeneratorType.init();
        int generatorAmount = buf.readInt();
        for (int i = 0; i < generatorAmount; ++i) {
            String id = buf.method_19772();
            String block = buf.method_19772();
            int generatorStress = buf.readInt();
            float generatorRatio = buf.readFloat();
            int generatorStorage = buf.readInt();
            GeneratorType.initializeNewType(id, new class_2960(block), generatorStress, generatorRatio, generatorStorage);
        }
        loaded = true;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        GeneratorTypeLoaderImpl.init();
    }
}

