/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.watut;

import com.corosus.coroutil.util.CULog;
import com.corosus.watut.FakePlayerHelper;
import com.corosus.watut.InventorySnapshot;
import com.corosus.watut.PlayerStatus;
import com.corosus.watut.PlayerStatusManager;
import com.corosus.watut.WatutMod;
import com.corosus.watut.WatutNetworking;
import com.corosus.watut.config.ConfigCommon;
import com.corosus.watut.config.ConfigServerControlledSyncedToClient;
import com.corosus.watut.config.ConfigServerSyncHelper;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class PlayerStatusManagerServer
extends PlayerStatusManager {
    @Override
    public void tickPlayer(class_1657 player) {
        this.getStatus(player).setTicksToMarkPlayerIdleSyncedForClient(ConfigCommon.ticksToMarkPlayerIdle);
        super.tickPlayer(player);
    }

    public void receiveAny(class_1657 player, class_2487 data) {
        data.method_10582(WatutNetworking.NBTDataPlayerUUID, player.method_5667().toString());
        if (data.method_10545(WatutNetworking.NBTDataPlayerGuiStatus)) {
            PlayerStatus.PlayerGuiState playerGuiState = PlayerStatus.PlayerGuiState.get(data.method_10550(WatutNetworking.NBTDataPlayerGuiStatus));
            this.getStatus(player).setPlayerGuiState(playerGuiState);
        }
        if (data.method_10545(WatutNetworking.NBTDataPlayerChatStatus)) {
            PlayerStatus.PlayerChatState state = PlayerStatus.PlayerChatState.get(data.method_10550(WatutNetworking.NBTDataPlayerChatStatus));
            this.getStatus(player).setPlayerChatState(state);
        }
        if (data.method_10545(WatutNetworking.NBTDataPlayerIdleTicks)) {
            this.handleIdleState(player, data.method_10550(WatutNetworking.NBTDataPlayerIdleTicks));
            data.method_10569(WatutNetworking.NBTDataPlayerTicksToGoIdle, ConfigCommon.ticksToMarkPlayerIdle);
        }
        if (data.method_10545(WatutNetworking.NBTDataPlayerMouseX)) {
            float x = data.method_10583(WatutNetworking.NBTDataPlayerMouseX);
            float y = data.method_10583(WatutNetworking.NBTDataPlayerMouseY);
            boolean pressed = data.method_10577(WatutNetworking.NBTDataPlayerMousePressed);
            this.setMouse(player.method_5667(), x, y, pressed);
        }
        this.getStatus(player).getNbtCache().method_10543(data);
        if (data.method_10545(WatutNetworking.NBTDataPlayerGuiStatus) || data.method_10545(WatutNetworking.NBTDataPlayerIdleTicks) || data.method_10545(WatutNetworking.NBTDataPlayerChatStatus)) {
            WatutNetworking.instance().serverSendToClientAll(data);
        } else {
            WatutNetworking.instance().serverSendToClientNear(data, player.method_19538(), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, player.method_37908());
        }
    }

    public void handleIdleState(class_1657 player, int idleTicks) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        PlayerStatus status = this.getStatus(player);
        if (WatutMod.instance().getPlayerList().method_14574() > 1 || this.singleplayerTesting) {
            if (idleTicks > ConfigCommon.ticksToMarkPlayerIdle) {
                if (!status.isIdle()) {
                    this.broadcast(player.method_5476().getString() + " has gone idle");
                }
            } else if (status.isIdle()) {
                this.broadcast(player.method_5476().getString() + " is no longer idle");
            }
        }
        status.setTicksSinceLastAction(idleTicks);
    }

    public void broadcast(String msg) {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        if (ConfigCommon.announceIdleStatesInChat) {
            WatutMod.instance().getPlayerList().method_43514((class_2561)class_2561.method_43470((String)msg), false);
        }
    }

    @Override
    public void playerLoggedIn(class_1657 player) {
        super.playerLoggedIn(player);
        WatutMod.dbg("player logged in " + player.method_5477());
        if (player instanceof class_3222) {
            for (Map.Entry entry : this.lookupPlayerToStatus.entrySet()) {
                WatutMod.dbg("sending update all packet for " + ((UUID)entry.getKey()).toString() + " to " + player.method_5476().getString() + " with status " + PlayerStatus.PlayerGuiState.get(((PlayerStatus)entry.getValue()).getNbtCache().method_10550(WatutNetworking.NBTDataPlayerGuiStatus)));
                WatutNetworking.instance().serverSendToClientPlayer(((PlayerStatus)entry.getValue()).getNbtCache(), player);
            }
            CULog.dbg((String)("sending server config sync to " + player.method_5477()));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), player);
        }
    }

    public void syncServerConfigToAllPlayers() {
        if (WatutMod.instance().getPlayerList() == null) {
            return;
        }
        for (class_3222 serverPlayer : WatutMod.instance().getPlayerList().method_14571()) {
            CULog.dbg((String)("sending server config sync to " + serverPlayer.method_5477()));
            WatutNetworking.instance().serverSendToClientPlayer(this.getServerConfigNBT(), (class_1657)serverPlayer);
        }
    }

    public class_2487 getServerConfigNBT() {
        class_2487 nbt = ConfigServerSyncHelper.getInstance().getSyncableConfigOnServer();
        nbt.method_10556(WatutNetworking.NBTDataServerConfig, true);
        return nbt;
    }

    public void sendItemMove(class_1657 player, class_1937 level, class_1799 itemStack, double fromX, double fromY, double fromZ, double toX, double toY, double toZ) {
        this.sendItemMove(player, level, itemStack, (float)fromX, (float)fromY, (float)fromZ, (float)toX, (float)toY, (float)toZ);
    }

    public void sendItemMove(class_1657 player, class_1937 level, class_1799 itemStack, float fromX, float fromY, float fromZ, float toX, float toY, float toZ) {
        if (level.method_8604((double)fromX, (double)fromY, (double)fromZ, (double)ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, entity -> entity != player) != null) {
            class_2487 data = new class_2487();
            data.method_10566(WatutNetworking.NBTDataItemTransferItemStack, (class_2520)itemStack.method_7953(new class_2487()));
            data.method_10548(WatutNetworking.NBTDataItemTransferFromX, fromX);
            data.method_10548(WatutNetworking.NBTDataItemTransferFromY, fromY);
            data.method_10548(WatutNetworking.NBTDataItemTransferFromZ, fromZ);
            data.method_10548(WatutNetworking.NBTDataItemTransferToX, toX);
            data.method_10548(WatutNetworking.NBTDataItemTransferToY, toY);
            data.method_10548(WatutNetworking.NBTDataItemTransferToZ, toZ);
            WatutNetworking.instance().serverSendToClientNear(data, new class_243((double)fromX, (double)fromY, (double)fromZ), ConfigServerControlledSyncedToClient.distanceRequiredToShowGUIInfo, level);
        }
    }

    public void makeNewInventorySnapshot(class_1703 abstractContainerMenu, class_1657 player) {
        PlayerStatus playerStatus = this.getStatus(player);
        playerStatus.getInventorySnapshotPlayer().itemStackList.clear();
        playerStatus.getInventorySnapshotContainer().itemStackList.clear();
        playerStatus.getInventorySnapshotCarried().itemStackList.clear();
        for (class_1799 item : player.method_31548().field_7547) {
            playerStatus.getInventorySnapshotPlayer().itemStackList.add(item.method_7972());
        }
        for (class_1735 slot : abstractContainerMenu.field_7761) {
            if (slot.field_7871 instanceof class_1661) continue;
            playerStatus.getInventorySnapshotContainer().itemStackList.add(slot.method_7677().method_7972());
        }
        if (!abstractContainerMenu.method_34255().method_7960()) {
            playerStatus.getInventorySnapshotCarried().itemStackList.add(abstractContainerMenu.method_34255().method_7972());
        }
    }

    public void doClickPre(class_1703 abstractContainerMenu, int pSlotId, int pButton, class_1713 pClickType, class_1657 player) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        if (playerStatus.getLastBlockOpened().equals((Object)class_2338.field_10980)) {
            return;
        }
        this.makeNewInventorySnapshot(abstractContainerMenu, player);
    }

    public void useBlock(class_1657 player, class_2338 pos) {
        if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
            return;
        }
        if (FakePlayerHelper.isFakePlayer(player)) {
            return;
        }
        PlayerStatus playerStatus = this.getStatus(player);
        if (playerStatus.isPlayerGuiDontSendItemInfo()) {
            return;
        }
        playerStatus.setLastBlockOpened(pos);
    }

    public void doClickPost(class_1703 abstractContainerMenu, int pSlotId, int pButton, class_1713 pClickType, class_1657 player) {
        block17: {
            List containerRemovedItems;
            List containerAddedItems;
            List playerRemovedItems;
            List playerAddedItems;
            block16: {
                if (!ConfigServerControlledSyncedToClient.showItemsBeingTransferredBetweenPlayerAndContainer) {
                    return;
                }
                if (FakePlayerHelper.isFakePlayer(player)) {
                    return;
                }
                PlayerStatus playerStatus = this.getStatus(player);
                if (playerStatus.isPlayerGuiDontSendItemInfo()) {
                    return;
                }
                if (playerStatus.getLastBlockOpened().equals((Object)class_2338.field_10980)) {
                    return;
                }
                InventorySnapshot inventorySnapshotPlayerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotContainerPost = new InventorySnapshot();
                InventorySnapshot inventorySnapshotCarriedPost = new InventorySnapshot();
                for (class_1799 item : player.method_31548().field_7547) {
                    inventorySnapshotPlayerPost.itemStackList.add(item.method_7972());
                }
                for (class_1735 slot : abstractContainerMenu.field_7761) {
                    if (slot.field_7871 instanceof class_1661) continue;
                    inventorySnapshotContainerPost.itemStackList.add(slot.method_7677().method_7972());
                }
                if (!abstractContainerMenu.method_34255().method_7960()) {
                    inventorySnapshotCarriedPost.itemStackList.add(abstractContainerMenu.method_34255().method_7972());
                }
                Pair<List<class_1799>, List<class_1799>> listsPlayer = this.processInventorySnapshots(playerStatus.getInventorySnapshotPlayer().itemStackList, inventorySnapshotPlayerPost.itemStackList);
                playerAddedItems = (List)listsPlayer.getFirst();
                playerRemovedItems = (List)listsPlayer.getSecond();
                Pair<List<class_1799>, List<class_1799>> listsContainer = this.processInventorySnapshots(playerStatus.getInventorySnapshotContainer().itemStackList, inventorySnapshotContainerPost.itemStackList);
                containerAddedItems = (List)listsContainer.getFirst();
                containerRemovedItems = (List)listsContainer.getSecond();
                if (pClickType != class_1713.field_7790) break block16;
                if (!abstractContainerMenu.method_34255().method_7960() && playerAddedItems.size() == 0 && containerAddedItems.size() == 0) {
                    class_1799 itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.method_34255(), playerRemovedItems);
                    if (itemStackCarriedMatch != null) {
                        playerStatus.setCarriedItemFromPlayerInventory(true);
                    } else {
                        itemStackCarriedMatch = this.getMatchingItem(abstractContainerMenu.method_34255(), containerRemovedItems);
                        if (itemStackCarriedMatch != null) {
                            playerStatus.setCarriedItemFromPlayerInventory(false);
                        }
                    }
                }
                if (playerStatus.getInventorySnapshotCarried().itemStackList.size() <= 0) break block17;
                class_1799 prevCarried = playerStatus.getInventorySnapshotCarried().itemStackList.get(0);
                for (class_1799 itemStackAdded : playerAddedItems) {
                    if (!class_1799.method_7984((class_1799)prevCarried, (class_1799)itemStackAdded) || playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
                for (class_1799 itemStackAdded : containerAddedItems) {
                    if (!class_1799.method_7984((class_1799)prevCarried, (class_1799)itemStackAdded) || !playerStatus.isCarriedItemFromPlayerInventory()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                break block17;
            }
            if (pClickType == class_1713.field_7794) {
                class_1799 itemStackAdded;
                for (class_1799 itemStackRemoved : playerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, containerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.method_7947() < itemStackRemoved.method_7947()) continue;
                    this.sendItemMove(player, itemStackAdded, true);
                }
                for (class_1799 itemStackRemoved : containerRemovedItems) {
                    itemStackAdded = this.getMatchingItem(itemStackRemoved, playerAddedItems);
                    if (itemStackAdded == null || itemStackAdded.method_7947() < itemStackRemoved.method_7947()) continue;
                    this.sendItemMove(player, itemStackAdded, false);
                }
            }
        }
    }

    public class_1799 getSimpleItemStack(class_1799 itemStack) {
        return new class_1799((class_1935)itemStack.method_7909(), itemStack.method_7947());
    }

    public Pair<List<class_1799>, List<class_1799>> processInventorySnapshots(List<class_1799> pre, List<class_1799> post) {
        ArrayList<class_1799> addedItems = new ArrayList<class_1799>();
        ArrayList<class_1799> removedItems = new ArrayList<class_1799>();
        for (int i = 0; i < post.size(); ++i) {
            class_1799 stack;
            class_1799 stackPost;
            class_1799 stackPre = pre.get(i);
            if (!class_1799.method_7984((class_1799)stackPre, (class_1799)(stackPost = post.get(i)))) {
                if (stackPre.method_7960() && !stackPost.method_7960()) {
                    addedItems.add(this.getSimpleItemStack(stackPost));
                    continue;
                }
                if (stackPre.method_7960() || !stackPost.method_7960()) continue;
                removedItems.add(this.getSimpleItemStack(stackPre));
                continue;
            }
            if (stackPre.method_7947() > stackPost.method_7947()) {
                stack = this.getSimpleItemStack(stackPre);
                stack.method_7939(stackPre.method_7947() - stackPost.method_7947());
                removedItems.add(stack);
                continue;
            }
            if (stackPre.method_7947() >= stackPost.method_7947()) continue;
            stack = this.getSimpleItemStack(stackPost);
            stack.method_7939(stackPost.method_7947() - stackPre.method_7947());
            addedItems.add(stack);
        }
        return Pair.of(addedItems, removedItems);
    }

    public class_1799 getMatchingItem(class_1799 itemStack, List<class_1799> itemStackList) {
        for (class_1799 itemStack1 : itemStackList) {
            if (!class_1799.method_7984((class_1799)itemStack, (class_1799)itemStack1)) continue;
            return itemStack1;
        }
        return null;
    }

    public void sendItemMove(class_1657 player, class_1799 itemStack, boolean toContainer) {
        PlayerStatus playerStatus = this.getStatus(player);
        class_2338 pos = playerStatus.getLastBlockOpened();
        float distFromFace = 0.55f;
        class_243 lookVec = this.getBodyAngle(player).method_1021((double)distFromFace);
        if (toContainer) {
            this.sendItemMove(player, player.method_37908(), itemStack, player.method_23317() + lookVec.field_1352, player.method_23318() + 1.2, player.method_23321() + lookVec.field_1350, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.7f), (double)((float)pos.method_10260() + 0.5f));
        } else {
            this.sendItemMove(player, player.method_37908(), itemStack, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 0.7f), (double)((float)pos.method_10260() + 0.5f), player.method_23317() + lookVec.field_1352, player.method_23318() + 1.2, player.method_23321() + lookVec.field_1350);
        }
    }
}

