/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.api.energy;

import aztech.modern_industrialization.MIConfig;
import aztech.modern_industrialization.MIIdentifier;
import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.api.energy.MIEnergyStorage;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.lookup.v1.item.ItemApiLookup;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.DelegatingEnergyStorage;
import team.reborn.energy.api.base.LimitingEnergyStorage;

public class EnergyApi {
    public static final BlockApiLookup<MIEnergyStorage, class_2350> SIDED = BlockApiLookup.get((class_2960)new MIIdentifier("sided_mi_energy_storage"), MIEnergyStorage.class, class_2350.class);
    public static final ItemApiLookup<EnergyStorage, ContainerItemContext> ITEM = ItemApiLookup.get((class_2960)new MIIdentifier("energy_storage"), EnergyStorage.class, ContainerItemContext.class);
    private static final ThreadLocal<Boolean> IN_COMPAT = ThreadLocal.withInitial(() -> false);
    public static final MIEnergyStorage CREATIVE = new MIEnergyStorage.NoInsert(){

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return maxAmount;
        }

        public long getAmount() {
            return Long.MAX_VALUE;
        }

        public long getCapacity() {
            return Long.MAX_VALUE;
        }
    };
    public static final MIEnergyStorage EMPTY = new EmptyStorage();

    static {
        if (MIConfig.getConfig().enableBidirectionalEnergyCompat) {
            EnergyStorage.SIDED.registerFallback((world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage energyStorage = (EnergyStorage)SIDED.find(world, pos, state, blockEntity, context);
                    return energyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
            SIDED.registerFallback((world, pos, state, blockEntity, context) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage trStorage = (EnergyStorage)EnergyStorage.SIDED.find(world, pos, state, blockEntity, context);
                    WrappedTrStorage wrappedTrStorage = trStorage == null ? null : new WrappedTrStorage(trStorage);
                    return wrappedTrStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
            EnergyStorage.ITEM.registerFallback((stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage energyStorage = (EnergyStorage)ITEM.find(stack, ctx);
                    return energyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
            ITEM.registerFallback((stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage energyStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, ctx);
                    return energyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
        } else {
            SIDED.registerFallback((world, pos, state, blockEntity, context) -> {
                EnergyStorage trStorage = (EnergyStorage)EnergyStorage.SIDED.find(world, pos, state, blockEntity, context);
                return trStorage == null || !trStorage.supportsInsertion() ? null : new InsertOnlyTrStorage(trStorage);
            });
            ITEM.registerFallback((stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage trStorage = (EnergyStorage)EnergyStorage.ITEM.find(stack, ctx);
                    LimitingEnergyStorage limitingEnergyStorage = trStorage == null || !trStorage.supportsInsertion() ? null : new LimitingEnergyStorage(trStorage, Long.MAX_VALUE, 0L);
                    return limitingEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
            EnergyStorage.ITEM.registerFallback((stack, ctx) -> {
                if (IN_COMPAT.get().booleanValue()) {
                    return null;
                }
                IN_COMPAT.set(true);
                try {
                    EnergyStorage miStorage = (EnergyStorage)ITEM.find(stack, ctx);
                    LimitingEnergyStorage limitingEnergyStorage = miStorage == null || !miStorage.supportsExtraction() ? null : new LimitingEnergyStorage(miStorage, 0L, Long.MAX_VALUE);
                    return limitingEnergyStorage;
                }
                finally {
                    IN_COMPAT.set(false);
                }
            });
        }
    }

    private record InsertOnlyTrStorage(EnergyStorage trStorage) implements MIEnergyStorage.NoExtract
    {
        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            return this.trStorage.insert(maxAmount, transaction);
        }

        public long getAmount() {
            return this.trStorage.getAmount();
        }

        public long getCapacity() {
            return this.trStorage.getCapacity();
        }
    }

    private static class WrappedTrStorage
    extends DelegatingEnergyStorage
    implements MIEnergyStorage {
        public WrappedTrStorage(EnergyStorage backingStorage) {
            super(backingStorage, null);
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return true;
        }
    }

    private static class EmptyStorage
    implements MIEnergyStorage.NoInsert,
    MIEnergyStorage.NoExtract {
        private EmptyStorage() {
        }

        @Override
        public boolean canConnect(CableTier cableTier) {
            return false;
        }

        public long getAmount() {
            return 0L;
        }

        public long getCapacity() {
            return 0L;
        }
    }
}

