/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.blocks.storage.tank;

import aztech.modern_industrialization.blocks.storage.AbstractStorageBlockItem;
import aztech.modern_industrialization.blocks.storage.tank.TankBlock;
import aztech.modern_industrialization.items.ContainerItem;
import aztech.modern_industrialization.util.FluidHelper;
import aztech.modern_industrialization.util.NbtHelper;
import java.util.List;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public class TankItem
extends AbstractStorageBlockItem<FluidVariant> {
    public TankItem(TankBlock block, FabricItemSettings settings) {
        super(block, (class_1792.class_1793)settings);
    }

    public void registerItemApi() {
        FluidStorage.ITEM.registerForItems((stack, context) -> new ContainerItem.GenericItemStorage<FluidVariant>(this, (ContainerItemContext)context), new class_1935[]{this});
    }

    @Override
    public FluidVariant getResource(class_1799 stack) {
        class_2487 tag = stack.method_7941("BlockEntityTag");
        if (tag != null) {
            return NbtHelper.getFluidCompatible(tag, "fluid");
        }
        return FluidVariant.blank();
    }

    @Override
    public void setResourceNoClean(class_1799 stack, FluidVariant resource) {
        class_2487 tag = stack.method_7911("BlockEntityTag");
        NbtHelper.putFluid(tag, "fluid", resource);
        this.onChange(stack);
    }

    @Override
    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (this.behaviour.isCreative()) {
            tooltip.add(FluidHelper.getFluidName(this.getResource(stack), true));
        } else {
            long capacity = this.behaviour.getCapacityForResource(this.getResource(stack));
            if (this.isEmpty(stack)) {
                if (!this.isUnlocked(stack)) {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage(this.getResource(stack), 0L, capacity));
                } else {
                    tooltip.addAll(FluidHelper.getTooltipForFluidStorage(FluidVariant.blank(), 0L, capacity));
                }
            } else {
                tooltip.addAll(FluidHelper.getTooltipForFluidStorage(this.getResource(stack), this.getAmount(stack), capacity));
            }
        }
        super.method_7851(stack, world, tooltip, context);
    }
}

