/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.inventory;

import aztech.modern_industrialization.inventory.AbstractConfigurableStack;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;

public class MIStorage<T, K extends TransferVariant<T>, S extends AbstractConfigurableStack<T, K>>
implements Storage<K> {
    final List<S> stacks;
    private final boolean oneSlotPerResource;

    protected MIStorage(List<S> stacks, boolean oneSlotPerResource) {
        this.stacks = stacks;
        this.oneSlotPerResource = oneSlotPerResource;
    }

    public long insert(K resource, long maxAmount, TransactionContext tx, Predicate<? super S> filter, boolean lockSlots) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        boolean containsResourceAlready = false;
        long totalInserted = 0L;
        for (int iter = 0; iter < 2; ++iter) {
            for (AbstractConfigurableStack stack : this.stacks) {
                boolean isSlotEmpty;
                if (!filter.test(stack)) continue;
                boolean bl = isSlotEmpty = stack.getAmount() == 0L && stack.getLockedInstance() == null;
                boolean canInsert = isSlotEmpty ? (this.oneSlotPerResource ? iter == 1 && !containsResourceAlready : iter == 1) : (stack.getAmount() == 0L ? stack.isResourceAllowedByLock(resource) : stack.getResource().equals(resource));
                if (canInsert) {
                    long inserted = Math.min(maxAmount - totalInserted, stack.getRemainingCapacityFor(resource));
                    if (inserted > 0L) {
                        stack.updateSnapshots(tx);
                        stack.setKey(resource);
                        stack.increment(inserted);
                        if (lockSlots) {
                            stack.enableMachineLock(resource.getObject());
                        }
                    }
                    totalInserted += inserted;
                }
                containsResourceAlready = containsResourceAlready || stack.getResource().equals(resource);
            }
        }
        return totalInserted;
    }

    public long insertAllSlot(K resource, long maxAmount, TransactionContext tx) {
        return this.insert(resource, maxAmount, tx, slot -> true, false);
    }

    public long insert(K resource, long maxAmount, TransactionContext transaction) {
        return this.insert(resource, maxAmount, transaction, AbstractConfigurableStack::canPipesInsert, false);
    }

    public long extract(K resource, long maxAmount, TransactionContext transaction, Predicate<? super S> filter) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        long amount = 0L;
        for (int i = 0; i < this.stacks.size() && amount < maxAmount; ++i) {
            if (!filter.test(this.stacks.get(i))) continue;
            amount += ((AbstractConfigurableStack)this.stacks.get(i)).extract(resource, maxAmount - amount, transaction);
        }
        return amount;
    }

    public long extract(K resource, long maxAmount, TransactionContext transaction) {
        return this.extract(resource, maxAmount, transaction, slot -> true);
    }

    public long extractAllSlot(K resource, long maxAmount, TransactionContext transaction, Predicate<? super S> filter) {
        StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
        long amount = 0L;
        for (int i = 0; i < this.stacks.size() && amount < maxAmount; ++i) {
            if (!filter.test(this.stacks.get(i))) continue;
            amount += ((AbstractConfigurableStack)this.stacks.get(i)).extractDirect(resource, maxAmount - amount, transaction);
        }
        return amount;
    }

    public long extractAllSlot(K resource, long maxAmount, TransactionContext transaction) {
        return this.extractAllSlot(resource, maxAmount, transaction, slot -> true);
    }

    public Iterator<StorageView<K>> iterator() {
        return this.stacks.iterator();
    }
}

