/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.machines.components;

import aztech.modern_industrialization.api.energy.CableTier;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.machines.MachineBlockEntity;
import aztech.modern_industrialization.machines.components.DropableComponent;
import aztech.modern_industrialization.machines.models.MachineCasing;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CasingComponent
implements IComponent,
DropableComponent {
    private class_1799 casingStack = class_1799.field_8037;
    private CableTier currentTier = CableTier.LV;

    private void setCasingStack(class_1799 stack) {
        this.casingStack = stack;
        this.currentTier = CasingComponent.getCasingTier(stack.method_7909());
        if (this.currentTier == null) {
            this.currentTier = CableTier.LV;
        }
    }

    @Override
    public void writeNbt(class_2487 tag) {
        tag.method_10566("casing", (class_2520)this.casingStack.method_7953(new class_2487()));
    }

    @Override
    public void readNbt(class_2487 tag) {
        if (tag.method_10573("casing", 8)) {
            CableTier tier = CableTier.getTier(tag.method_10558("casing"));
            this.setCasingStack(((class_1792)class_7923.field_41178.method_10223(tier.itemKey)).method_7854());
        } else {
            this.setCasingStack(class_1799.method_7915((class_2487)tag.method_10562("casing")));
        }
    }

    @Override
    public void writeClientNbt(class_2487 tag) {
        tag.method_10582("casing", this.currentTier.name);
    }

    @Override
    public void readClientNbt(class_2487 tag) {
        this.currentTier = CableTier.getTier(tag.method_10558("casing"));
    }

    public void dropCasing(class_1937 world, class_2338 pos) {
        class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)this.casingStack);
    }

    public class_1269 onUse(MachineBlockEntity be, class_1657 player, class_1268 hand) {
        CableTier newTier;
        class_1799 stackInHand = player.method_5998(hand);
        if (stackInHand.method_7947() >= 1 && (newTier = CasingComponent.getCasingTier(stackInHand.method_7909())) != null && newTier != this.currentTier) {
            if (this.currentTier != CableTier.LV) {
                this.dropCasing(be.method_10997(), be.method_11016());
            }
            this.setCasingStack(stackInHand.method_46651(1));
            if (!player.method_7337()) {
                stackInHand.method_7934(1);
            }
            be.method_5431();
            if (!be.method_10997().method_8608()) {
                be.sync();
            }
            be.method_10997().method_8452(be.method_11016(), class_2246.field_10124);
            this.playCasingPlaceSound(be);
            return class_1269.method_29236((boolean)be.method_10997().field_9236);
        }
        return class_1269.field_5811;
    }

    private void playCasingPlaceSound(MachineBlockEntity be) {
        class_2960 blockKey = this.currentTier.itemKey;
        if (blockKey == null) {
            return;
        }
        class_7923.field_41175.method_17966(blockKey).ifPresent(block -> {
            class_2680 casingState = block.method_9564();
            class_2498 group = casingState.method_26231();
            class_3414 sound = group.method_10595();
            be.method_10997().method_8396(null, be.method_11016(), sound, class_3419.field_15245, (group.method_10597() + 1.0f) / 4.0f, group.method_10599() * 0.8f);
        });
    }

    @Nullable
    public static CableTier getCasingTier(class_1792 item) {
        class_2960 itemKey = class_7923.field_41178.method_10221((Object)item);
        for (CableTier tier : CableTier.allTiers()) {
            if (tier.itemKey == null || !tier.itemKey.equals((Object)itemKey)) continue;
            return tier;
        }
        return null;
    }

    @Override
    public class_1799 getDrop() {
        return this.casingStack;
    }

    public void setCasingServer(MachineBlockEntity be, class_1799 casing) {
        this.setCasingStack(casing);
        be.method_5431();
        be.sync();
        be.method_10997().method_8452(be.method_11016(), class_2246.field_10124);
        this.playCasingPlaceSound(be);
    }

    public MachineCasing getCasing() {
        return this.currentTier.casing;
    }

    public boolean canInsertEu(CableTier tier) {
        return tier == this.currentTier;
    }

    public long getEuCapacity() {
        return this.currentTier.getEu() * 100L;
    }
}

