/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.textures;

import aztech.modern_industrialization.materials.Material;
import aztech.modern_industrialization.materials.part.MIParts;
import aztech.modern_industrialization.materials.part.MaterialItemPart;
import aztech.modern_industrialization.materials.part.NuclearFuelPart;
import aztech.modern_industrialization.materials.part.PartKeyProvider;
import aztech.modern_industrialization.materials.part.TextureGenParams;
import aztech.modern_industrialization.materials.property.MaterialProperty;
import aztech.modern_industrialization.materials.set.MaterialBlockSet;
import aztech.modern_industrialization.materials.set.MaterialOreSet;
import aztech.modern_industrialization.materials.set.MaterialRawSet;
import aztech.modern_industrialization.textures.MITextures;
import aztech.modern_industrialization.textures.TextureHelper;
import aztech.modern_industrialization.textures.TextureManager;
import aztech.modern_industrialization.textures.coloramp.DepletedColoramp;
import aztech.modern_industrialization.textures.coloramp.HotIngotColoramp;
import aztech.modern_industrialization.textures.coloramp.IColoramp;
import java.io.IOException;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;

@Environment(value=EnvType.CLIENT)
class PartTextureGenerator {
    private final IColoramp coloramp;
    private final TextureManager mtm;
    private final Material material;
    private final String materialName;
    private final String itemPath;

    static void processPart(IColoramp coloramp, TextureManager mtm, Material material, MaterialItemPart part) {
        PartTextureGenerator gen = new PartTextureGenerator(coloramp, mtm, material, part);
        try {
            gen.build(part);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private PartTextureGenerator(IColoramp coloramp, TextureManager mtm, Material material, MaterialItemPart part) {
        this.coloramp = coloramp;
        this.mtm = mtm;
        this.material = material;
        this.materialName = material.name;
        this.itemPath = new class_2960(part.getItemId()).method_12832();
    }

    private void build(MaterialItemPart part) throws IOException {
        TextureGenParams params = part.getTextureGenParams();
        if (params instanceof TextureGenParams.Block) {
            TextureGenParams.Block block = (TextureGenParams.Block)params;
            this.processBlock(block.blockSet());
        } else if (params instanceof TextureGenParams.CasingBlock) {
            this.processCasing(part);
        } else if (params instanceof TextureGenParams.ColumnBlock) {
            this.processColumn(part);
        } else if (params instanceof TextureGenParams.DepletedNuclear) {
            this.processDepletedNuclear();
        } else if (params instanceof TextureGenParams.DoubleIngot) {
            this.processDoubleIngot(part);
        } else if (params instanceof TextureGenParams.Gem) {
            this.processGem();
        } else if (params instanceof TextureGenParams.HotIngot) {
            this.processHotIngot();
        } else if (params instanceof TextureGenParams.Ore) {
            TextureGenParams.Ore ore = (TextureGenParams.Ore)params;
            this.processOre(ore.deepslate(), ore.oreSet());
        } else if (params instanceof TextureGenParams.RawMetal) {
            TextureGenParams.RawMetal rawMetal = (TextureGenParams.RawMetal)params;
            this.processRawMetal(rawMetal.isBlock(), rawMetal.rawSet());
        } else if (params instanceof TextureGenParams.SimpleRecoloredBlock) {
            MITextures.generateItemPartTexture(this.mtm, part.key().key, this.material.get(MaterialProperty.SET).name, this.itemPath, true, this.coloramp);
        } else if (params instanceof TextureGenParams.SimpleRecoloredItem) {
            TextureGenParams.SimpleRecoloredItem item = (TextureGenParams.SimpleRecoloredItem)params;
            String partTemplate = ((PartKeyProvider)Objects.requireNonNullElse(item.basePart(), part)).key().key;
            MITextures.generateItemPartTexture(this.mtm, partTemplate, item.overlay(), this.material.get(MaterialProperty.SET).name, this.itemPath, false, this.coloramp);
        } else if (!(params instanceof TextureGenParams.NoTexture)) {
            throw new IllegalArgumentException("Unknown texture gen params class " + params.getClass().getSimpleName());
        }
    }

    private void processBlock(MaterialBlockSet set) throws IOException {
        String template = String.format("modern_industrialization:textures/materialsets/blocks/%s.png", set.name);
        try (class_1011 image = this.mtm.getAssetAsTexture(template);){
            TextureHelper.colorize(image, this.coloramp);
            String texturePath = String.format("modern_industrialization:textures/block/%s.png", this.itemPath);
            this.mtm.addTexture(texturePath, image);
        }
    }

    private void processCasing(PartKeyProvider part) throws IOException {
        try (class_1011 image = MITextures.generateTexture(this.mtm, part.key().key, this.material.get(MaterialProperty.SET).name, this.coloramp);){
            MITextures.appendTexture(this.mtm, image, this.itemPath, true);
        }
    }

    private void processColumn(PartKeyProvider part) {
        for (String suffix : new String[]{"side", "top"}) {
            MITextures.generateItemPartTexture(this.mtm, part.key().key + "_" + suffix, this.material.get(MaterialProperty.SET).name, this.itemPath + "_" + suffix, true, this.coloramp);
        }
    }

    private void processDepletedNuclear() {
        MITextures.generateItemPartTexture(this.mtm, NuclearFuelPart.Type.SIMPLE.key, "common", this.itemPath, false, new DepletedColoramp(this.coloramp));
    }

    private void processDoubleIngot(PartKeyProvider part) {
        this.mtm.runAtEnd(() -> {
            try {
                MITextures.generateDoubleIngot(this.mtm, this.materialName);
            }
            catch (Throwable throwable) {
                MITextures.logTextureGenerationError(throwable, this.materialName, this.material.get(MaterialProperty.SET).name, part.key().key);
            }
        });
    }

    private void processGem() throws IOException {
        String template = String.format("modern_industrialization:textures/materialsets/gems/%s.png", this.materialName);
        try (class_1011 image = this.mtm.getAssetAsTexture(template);){
            TextureHelper.colorize(image, this.coloramp);
            String texturePath = String.format("modern_industrialization:textures/item/%s.png", this.itemPath);
            this.mtm.addTexture(texturePath, image);
        }
    }

    private void processHotIngot() {
        MITextures.generateItemPartTexture(this.mtm, MIParts.INGOT.key().key, this.material.get(MaterialProperty.SET).name, this.itemPath, false, new HotIngotColoramp(this.coloramp, 0.1, 0.5));
    }

    private void processOre(boolean deepslate, MaterialOreSet oreSet) throws IOException {
        String template = String.format("modern_industrialization:textures/materialsets/ores/%s.png", oreSet.name);
        String from = switch (oreSet) {
            case MaterialOreSet.IRON -> {
                if (deepslate) {
                    yield "deepslate_iron_ore";
                }
                yield "iron_ore";
            }
            case MaterialOreSet.COPPER -> {
                if (deepslate) {
                    yield "deepslate_copper_ore";
                }
                yield "copper_ore";
            }
            case MaterialOreSet.LAPIS -> {
                if (deepslate) {
                    yield "deepslate_lapis_ore";
                }
                yield "lapis_ore";
            }
            case MaterialOreSet.REDSTONE -> {
                if (deepslate) {
                    yield "deepslate";
                }
                yield "redstone_ore";
            }
            case MaterialOreSet.DIAMOND -> {
                if (deepslate) {
                    yield "deepslate";
                }
                yield "diamond_ore";
            }
            case MaterialOreSet.GOLD -> {
                if (deepslate) {
                    yield "deepslate_gold_ore";
                }
                yield "gold_ore";
            }
            case MaterialOreSet.EMERALD -> {
                if (deepslate) {
                    yield "deepslate_emerald_ore";
                }
                yield "emerald_ore";
            }
            case MaterialOreSet.COAL -> {
                if (deepslate) {
                    yield "deepslate_coal_ore";
                }
                yield "coal_ore";
            }
            default -> deepslate ? "deepslate" : "stone";
        };
        try (class_1011 image = this.mtm.getAssetAsTexture(String.format("minecraft:textures/block/%s.png", from));
             class_1011 top = this.mtm.getAssetAsTexture(template);){
            TextureHelper.colorize(top, this.coloramp);
            String texturePath = String.format("modern_industrialization:textures/block/%s.png", this.itemPath);
            this.mtm.addTexture(texturePath, TextureHelper.blend(image, top), true);
        }
    }

    private void processRawMetal(boolean isBlock, MaterialRawSet rawSet) throws IOException {
        String template = String.format("modern_industrialization:textures/materialsets/raw/%s.png", rawSet.name + (isBlock ? "_block" : ""));
        try (class_1011 image = this.mtm.getAssetAsTexture(template);){
            TextureHelper.colorize(image, this.coloramp);
            String texturePath = isBlock ? String.format("modern_industrialization:textures/block/%s.png", this.itemPath) : String.format("modern_industrialization:textures/item/%s.png", this.itemPath);
            this.mtm.addTexture(texturePath, image);
        }
    }
}

