/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.anim;

import java.util.Random;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.anim.SwingAnimation;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.joml.Vector3f;

public class SwayingAnimation
extends SwingAnimation {
    protected float maxSwingAngle = 45.0f;
    protected float minSwingAngle = 2.5f;
    protected float maxPeriod = 25.0f;
    protected float angleDamping = 150.0f;
    protected float periodDamping = 100.0f;
    private int animationCounter = 800 + new Random().nextInt(80);
    private boolean inv = false;

    public SwayingAnimation(Supplier<Vector3f> getRotationAxis) {
        super(getRotationAxis);
    }

    @Override
    public void tick(boolean inWater) {
        ++this.animationCounter;
        double timer = this.animationCounter;
        if (inWater) {
            timer /= 2.0;
        }
        this.prevAngle = this.angle;
        float a = this.minSwingAngle;
        float k = 0.01f;
        if (timer < 800.0) {
            a = (float)Math.max((double)this.maxSwingAngle * Math.exp(-(timer / (double)this.angleDamping)), (double)this.minSwingAngle);
            k = (float)Math.max(Math.PI * 2 * (double)((float)Math.exp(-(timer / (double)this.periodDamping))), (double)0.01f);
        }
        this.angle = a * class_3532.method_15362((float)((float)(timer / (double)this.maxPeriod - (double)k)));
        this.angle *= this.inv ? -1.0f : 1.0f;
    }

    @Override
    public void addImpulse(float vel) {
    }

    @Override
    public void addPositiveImpulse(float vel) {
    }

    @Override
    public float getAngle(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.prevAngle, (float)this.angle);
    }

    @Override
    public void reset() {
        this.animationCounter = 800;
    }

    @Override
    public boolean hit(class_243 mot, double eMass) {
        if (mot.method_1033() > 0.05) {
            class_243 vec;
            class_243 norm = new class_243(mot.field_1352, 0.0, mot.field_1350).method_1029();
            double dot = norm.method_1026(vec = new class_243((Vector3f)this.rotationAxis.get()));
            if (dot != 0.0) {
                boolean bl = this.inv = dot < 0.0;
            }
            if (Math.abs(dot) > 0.4) {
                if (this.animationCounter > 10) {
                    this.animationCounter = 0;
                    return true;
                }
                this.animationCounter = 0;
            }
        }
        return false;
    }

    @Override
    public boolean hitByEntity(class_1297 entity) {
        class_243 mot = entity.method_18798();
        return this.hit(mot, 1.0);
    }
}

