/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.compat;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.compat.AccessoriesCompat;
import dev.lambdaurora.lambdynlights.compat.CuriosCompat;
import dev.lambdaurora.lambdynlights.compat.TrinketsCompat;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import org.jetbrains.annotations.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CompatLayer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"LambDynamicLights|CompatLayer");
    public static final List<CompatLayer> LAYERS = CompatLayer.initLayers();

    public @Range(from=0L, to=15L) int getLivingEntityLuminanceFromItems(ItemLightSourceManager var1, class_1309 var2, boolean var3);

    private static List<CompatLayer> initLayers() {
        ArrayList<CompatLayer> layers = new ArrayList<CompatLayer>();
        try {
            if (FabricLoader.getInstance().isModLoaded("accessories")) {
                layers.add(new AccessoriesCompat());
            } else if (FabricLoader.getInstance().isModLoaded("trinkets")) {
                if (FabricLoader.getInstance().isModLoaded("radiantgear")) {
                    LambDynLights.warn(LOGGER, "Radiant Gear has been detected, built-in Trinkets integration will not be enabled.");
                    LambDynLights.warn(LOGGER, "Radiant Gear is no longer needed on Fabric with LambDynamicLights.");
                } else {
                    layers.add(new TrinketsCompat());
                }
            } else if (FabricLoader.getInstance().isModLoaded("curios") && !FabricLoader.getInstance().isModLoaded("radiantgear")) {
                layers.add(new CuriosCompat());
            }
        }
        catch (LinkageError e) {
            LambDynLights.error(LOGGER, "Could not load a compatibility layer: THIS IS VERY WRONG, PLEASE REPORT THIS ERROR TO LAMBDYNAMICLIGHTS' AUTHOR ASAP.", e);
        }
        return layers;
    }
}

