/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.component.ComponentUtils;
import com.tiviacz.travelersbackpack.init.ModNetwork;
import com.tiviacz.travelersbackpack.inventory.BackpackContainer;
import com.tiviacz.travelersbackpack.inventory.upgrades.tanks.TankActions;
import com.tiviacz.travelersbackpack.network.IPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;

public record ServerboundActionTagPacket(class_2487 actionTag) implements IPacket<ServerboundActionTagPacket>
{
    public static final int UPGRADE_TAB = 0;
    public static final int OPEN_SCREEN = 1;
    public static final int OPEN_BACKPACK = 2;
    public static final int SORTER = 3;
    public static final int SLEEPING_BAG = 4;
    public static final int FILL_TANK = 5;
    public static final int SWAP_TOOL = 6;
    public static final int TOGGLE_BUTTONS_VISIBILITY = 7;
    public static final int SHOW_TOOL_SLOTS = 8;
    public static final int REMOVE_UPGRADE = 9;
    public static final int OPEN_SETTINGS = 10;
    public static final int SWITCH_HOSE_MODE = 11;
    public static final int SWITCH_HOSE_TANK = 12;
    public static final int TOGGLE_VISIBILITY = 13;
    public static final int ABILITY_SLIDER = 14;
    public static final int EQUIP_BACKPACK = 15;

    public static ServerboundActionTagPacket decode(class_2540 buffer) {
        class_2487 actionTag = buffer.method_10798();
        return new ServerboundActionTagPacket(actionTag);
    }

    @Override
    public void encode(ServerboundActionTagPacket message, class_2540 buffer) {
        buffer.method_10794(message.actionTag);
    }

    public static void handle(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender) {
        ServerboundActionTagPacket message = ServerboundActionTagPacket.decode(buf);
        server.execute(() -> {
            class_2487 actionTag = message.actionTag();
            int actionType = actionTag.method_10550("ActionType");
            switch (actionType) {
                case 0: {
                    int slot = actionTag.method_10550("Arg0");
                    boolean open = actionTag.method_10577("Arg1");
                    int packetType = actionTag.method_10550("Arg2");
                    ServerActions.modifyUpgradeTab(player, slot, open, packetType);
                    break;
                }
                case 1: {
                    if (!ComponentUtils.isWearingBackpack((class_1657)player)) break;
                    BackpackContainer.openBackpack(player, ComponentUtils.getWearingBackpack((class_1657)player), 2);
                    break;
                }
                case 2: {
                    int index = actionTag.method_10550("Arg0");
                    boolean fromSlot = actionTag.method_10577("Arg1");
                    ServerActions.openBackpackFromSlot(player, index, fromSlot);
                    break;
                }
                case 3: {
                    int button = actionTag.method_10550("Arg0");
                    boolean shiftPressed = actionTag.method_10577("Arg1");
                    ServerActions.sortBackpack((class_1657)player, button, shiftPressed);
                    break;
                }
                case 4: {
                    class_2338 pos = class_2338.method_10092((long)actionTag.method_10537("Arg0"));
                    boolean isEquipped = actionTag.method_10577("Arg1");
                    ServerActions.toggleSleepingBag((class_1657)player, pos, isEquipped);
                    break;
                }
                case 5: {
                    boolean leftTank = actionTag.method_10577("Arg0");
                    TankActions.fillTank(player, leftTank);
                    break;
                }
                case 6: {
                    double scrollDelta = actionTag.method_10574("Arg0");
                    ServerActions.swapTool((class_1657)player, scrollDelta);
                    break;
                }
                case 7: {
                    ServerActions.toggleButtonsVisibility((class_1657)player);
                    break;
                }
                case 8: {
                    boolean show = actionTag.method_10577("Arg0");
                    ServerActions.showToolSlots(player, show);
                    break;
                }
                case 9: {
                    int slot = actionTag.method_10550("Arg0");
                    ServerActions.removeBackpackUpgrade(player, slot);
                    break;
                }
                case 10: {
                    int entityId = actionTag.method_10550("Arg0");
                    boolean open = actionTag.method_10577("Arg1");
                    ServerActions.openBackpackSettings(player, entityId, open);
                    break;
                }
                case 11: {
                    double scrollDelta = actionTag.method_10574("Arg0");
                    ServerActions.switchHoseMode((class_1657)player, scrollDelta);
                    break;
                }
                case 12: {
                    ServerActions.toggleHoseTank((class_1657)player);
                    break;
                }
                case 13: {
                    ServerActions.toggleVisibility((class_1657)player);
                    break;
                }
                case 14: {
                    boolean sliderValue = actionTag.method_10577("Arg0");
                    ServerActions.switchAbilitySlider(player, sliderValue);
                    break;
                }
                case 15: {
                    boolean equip = actionTag.method_10577("Arg0");
                    ServerActions.equipBackpack((class_1657)player, equip);
                }
            }
        });
    }

    public static void create(int type, Object ... args) {
        PacketDistributorHelper.sendToServer(new ServerboundActionTagPacket(ServerboundActionTagPacket.createPacketTag(type, args)));
    }

    public static class_2487 createPacketTag(int type, Object ... args) {
        class_2487 tag = new class_2487();
        tag.method_10569("ActionType", type);
        for (int i = 0; i < args.length; ++i) {
            String argName = "Arg" + i;
            Object object = args[i];
            if (object instanceof class_2338) {
                class_2338 blockPos = (class_2338)object;
                tag.method_10544(argName, blockPos.method_10063());
                continue;
            }
            if (args[i] instanceof Boolean) {
                tag.method_10556(argName, ((Boolean)args[i]).booleanValue());
                continue;
            }
            if (args[i] instanceof Byte) {
                tag.method_10567(argName, ((Byte)args[i]).byteValue());
                continue;
            }
            if (args[i] instanceof Integer) {
                tag.method_10569(argName, ((Integer)args[i]).intValue());
                continue;
            }
            if (!(args[i] instanceof Double)) continue;
            tag.method_10549(argName, ((Double)args[i]).doubleValue());
        }
        return tag;
    }

    @Override
    public class_2960 getPacketId() {
        return ModNetwork.ACTION_TAG_ID;
    }
}

