/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitminers.extendedgears.cogwheels.materials;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.rabbitminers.extendedgears.base.networking.PlayerSelection;
import com.rabbitminers.extendedgears.base.networking.S2CPacket;
import com.rabbitminers.extendedgears.base.util.Env;
import com.rabbitminers.extendedgears.cogwheels.materials.ClientCogwheelMaterial;
import com.rabbitminers.extendedgears.cogwheels.materials.CogwheelMaterial;
import com.rabbitminers.extendedgears.registry.ExtendedCogwheelsPackets;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class CogwheelMaterialManager {
    public static Map<class_2960, CogwheelMaterial> MATERIALS = new HashMap<class_2960, CogwheelMaterial>();
    public static Map<class_2960, ClientCogwheelMaterial> CLIENT_MATERIALS = new HashMap<class_2960, ClientCogwheelMaterial>();
    public static Map<class_1792, class_2960> ITEM_TO_MATERIALS = new IdentityHashMap<class_1792, class_2960>();
    private static boolean dirty = false;

    @Nullable
    public static class_2960 of(class_1799 stack) {
        if (dirty) {
            CogwheelMaterialManager.fillItemMap();
            dirty = false;
        }
        return ITEM_TO_MATERIALS.get(stack.method_7909());
    }

    public static CogwheelMaterial of(class_2960 location) {
        return MATERIALS.get(location);
    }

    @Nullable
    public static ClientCogwheelMaterial clientOf(class_2960 location) {
        return CLIENT_MATERIALS.get(location);
    }

    public static int getStressLimit(class_2960 location) {
        CogwheelMaterial material = CogwheelMaterialManager.of(location);
        if (material == null) {
            return Integer.MAX_VALUE;
        }
        return material.stressLimit;
    }

    public static int getSpeedLimit(class_2960 location) {
        CogwheelMaterial material = CogwheelMaterialManager.of(location);
        if (material == null) {
            return (Integer)AllConfigs.server().kinetics.maxRotationSpeed.get();
        }
        return material.stressLimit;
    }

    public static void toBuffer(class_2540 buffer) {
        buffer.method_10804(MATERIALS.size());
        for (Map.Entry<class_2960, CogwheelMaterial> entry : MATERIALS.entrySet()) {
            buffer.method_10812(entry.getKey());
            entry.getValue().toBuffer(buffer);
        }
    }

    public static void fromBuffer(class_2540 buffer) {
        CogwheelMaterialManager.clear();
        int size = buffer.method_10816();
        for (int i = 0; i < size; ++i) {
            class_2960 id = buffer.method_10810();
            int itemSize = buffer.method_10816();
            class_2371 items = class_2371.method_10211();
            for (int j = 0; j < itemSize; ++j) {
                items.add((Object)class_1856.method_8086((class_2540)buffer));
            }
            int speedLimit = buffer.readInt();
            int stressLimit = buffer.readInt();
            CogwheelMaterial material = MATERIALS.get(id);
            if (material == null) continue;
            material.items = items;
            material.speedLimit = speedLimit;
            material.stressLimit = stressLimit;
        }
        dirty = true;
    }

    public static void clear() {
        ITEM_TO_MATERIALS.clear();
    }

    public static void syncTo(class_3222 player) {
        ExtendedCogwheelsPackets.PACKETS.sendTo(PlayerSelection.of(player), (S2CPacket)new SyncPacket());
    }

    public static void syncToAll() {
        ExtendedCogwheelsPackets.PACKETS.sendTo(PlayerSelection.all(), (S2CPacket)new SyncPacket());
    }

    public static void applyReloadListener(Map<class_2960, JsonElement> map) {
        CogwheelMaterialManager.clear();
        for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
            CogwheelMaterial type;
            JsonElement element = entry.getValue();
            if (!element.isJsonObject() || (type = MATERIALS.get(entry.getKey())) == null) continue;
            JsonObject object = element.getAsJsonObject();
            type.updateFromJson(object);
        }
        dirty = true;
    }

    public static void setupClientCogwheelMaterials() {
        if (Env.CURRENT == Env.CLIENT) {
            for (Map.Entry<class_2960, CogwheelMaterial> entry : MATERIALS.entrySet()) {
                CLIENT_MATERIALS.put(entry.getKey(), ClientCogwheelMaterial.fromMaterial(entry.getValue()));
            }
        }
    }

    public static void fillItemMap() {
        for (CogwheelMaterial material : MATERIALS.values()) {
            for (class_1856 ingredient : material.items) {
                for (class_1799 itemStack : ingredient.method_8105()) {
                    ITEM_TO_MATERIALS.put(itemStack.method_7909(), material.id);
                }
            }
        }
    }

    public static class SyncPacket
    implements S2CPacket {
        private class_2540 buffer;

        public SyncPacket() {
        }

        public SyncPacket(class_2540 buffer) {
            this.buffer = buffer;
        }

        @Override
        public void write(class_2540 buffer) {
            CogwheelMaterialManager.toBuffer(buffer);
        }

        @Override
        public void handle(class_310 mc) {
            try {
                CogwheelMaterialManager.fromBuffer(this.buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

