/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.mrturtle.analog.Analog;
import dev.mrturtle.analog.config.AnalogConfig;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    public static final int CONFIG_VERSION = 1;
    private static final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("analog.json");
    public static AnalogConfig config;

    public static void loadConfig() {
        try {
            File configFile = configPath.toFile();
            if (configFile.exists()) {
                Gson gson = new Gson();
                FileReader reader = new FileReader(configFile);
                config = (AnalogConfig)gson.fromJson((Reader)reader, AnalogConfig.class);
                reader.close();
                if (ConfigManager.config.configVersion < 1) {
                    ConfigManager.updateConfig();
                }
            } else {
                ConfigManager.createDefaultConfig();
            }
        }
        catch (Exception e) {
            Analog.LOGGER.error("Something went wrong while loading config file!");
            e.printStackTrace();
        }
    }

    public static void updateConfig() {
        File configFile = configPath.toFile();
        try {
            int oldVersion = ConfigManager.config.configVersion;
            ConfigManager.config.configVersion = 1;
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(configFile);
            writer.write(gson.toJson((Object)config));
            writer.close();
            Analog.LOGGER.info("Updated config from VERSION {} to VERSION {}", (Object)oldVersion, (Object)1);
        }
        catch (Exception e) {
            Analog.LOGGER.error("Something went wrong while updating config file!");
            e.printStackTrace();
        }
    }

    public static void createDefaultConfig() {
        File configFile = configPath.toFile();
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(configFile);
            config = ConfigManager.getDefaultConfig();
            writer.write(gson.toJson((Object)config));
            writer.close();
        }
        catch (Exception e) {
            Analog.LOGGER.error("Something went wrong while saving config file!");
            e.printStackTrace();
        }
    }

    public static AnalogConfig getDefaultConfig() {
        return new AnalogConfig();
    }
}

