/*
 * Decompiled with CFR 0.152.
 */
package dev.mrturtle.analog.mixin;

import dev.mrturtle.analog.Analog;
import dev.mrturtle.analog.AnalogPlugin;
import dev.mrturtle.analog.audio.RadioAudioInstance;
import dev.mrturtle.analog.audio.assets.MusicAssetManager;
import dev.mrturtle.analog.block.TransmitterBlockEntity;
import dev.mrturtle.analog.config.ConfigManager;
import dev.mrturtle.analog.util.RadioAudioUtil;
import dev.mrturtle.analog.util.RadioUtil;
import dev.mrturtle.analog.world.GlobalRadioState;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1301;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1813;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_8181;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2619.class})
public abstract class JukeboxBlockEntityMixin
extends class_2586
implements class_8181 {
    @Shadow
    private long field_39483;
    @Shadow
    private long field_39482;
    @Unique
    private short[] cachedAudio = null;

    @Shadow
    public abstract boolean method_44373();

    public JukeboxBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Inject(method={"startPlaying"}, at={@At(value="TAIL")})
    public void startPlaying(CallbackInfo ci) {
        if (!this.method_11002() || this.field_11863.field_9236) {
            return;
        }
        class_1792 class_17922 = this.method_49274().method_7909();
        if (!(class_17922 instanceof class_1813)) {
            return;
        }
        class_1813 discItem = (class_1813)class_17922;
        class_2960 songId = discItem.method_8009().method_14833();
        if (!songId.method_12836().equals("minecraft")) {
            return;
        }
        boolean isAudioPlayerDisc = false;
        class_2487 nbt = this.method_49274().method_7969();
        if (nbt != null && nbt.method_25928("CustomSound")) {
            isAudioPlayerDisc = true;
        }
        if (!isAudioPlayerDisc && !MusicAssetManager.recordsLoaded) {
            class_1657 closestPlayer = this.field_11863.method_8604((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260(), 8.0, class_1301.field_6155);
            if (closestPlayer != null) {
                closestPlayer.method_7353((class_2561)class_2561.method_43471((String)"gui.analog.jukebox.asset_failure"), true);
            }
            return;
        }
        this.cachedAudio = null;
        if (!isAudioPlayerDisc) {
            String songPath = "analog/records/%s.ogg".formatted(songId.method_12832().replace("music_disc.", ""));
            try {
                this.cachedAudio = RadioAudioUtil.getAudioData(FabricLoader.getInstance().getConfigDir().resolve(songPath));
            }
            catch (Exception e) {
                Analog.LOGGER.error("Failed to load music disc for playback from path %s".formatted(songPath));
                e.printStackTrace();
            }
        } else {
            String songExtension;
            String songName = "%s".formatted(nbt.method_25926("CustomSound"));
            Path basePath = this.field_11863.method_8503().method_27050(class_5218.field_24188).resolve("audio_player_data");
            if (!Files.exists(basePath.resolve(songName + (songExtension = ".wav")), new LinkOption[0])) {
                songExtension = ".mp3";
            }
            try {
                this.cachedAudio = RadioAudioUtil.getAudioData(basePath.resolve(songName + songExtension));
            }
            catch (Exception e) {
                Analog.LOGGER.error("Failed to load a custom Audio Player music disc for playback from path %s".formatted(songName + songExtension));
                e.printStackTrace();
            }
        }
        this.makeNearbyTransmittersPlay(true);
    }

    @Inject(method={"stopPlaying"}, at={@At(value="TAIL")})
    public void stopPlaying(CallbackInfo ci) {
        if (!this.method_11002() || this.field_11863.field_9236) {
            return;
        }
        GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState((class_3218)this.field_11863);
        class_243 center = this.field_11867.method_46558();
        for (class_2338 transmitterPos : globalRadioState.getTransmitters()) {
            TransmitterBlockEntity transmitter;
            if (center.method_1022(transmitterPos.method_46558()) > (double)ConfigManager.config.radioListeningDistance || (transmitter = (TransmitterBlockEntity)this.field_11863.method_8321(transmitterPos)) == null || !transmitter.enabled) continue;
            globalRadioState.audioManager.stopTransmitter(transmitterPos, this.field_11867.method_10062());
        }
    }

    @Inject(method={"tick(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V"}, at={@At(value="TAIL")})
    public void tick(class_1937 world, class_2338 pos, class_2680 state, CallbackInfo ci) {
        if (!this.method_44373()) {
            return;
        }
        this.makeNearbyTransmittersPlay(false);
    }

    @Unique
    private void makeNearbyTransmittersPlay(boolean overrideExisting) {
        if (this.cachedAudio == null) {
            return;
        }
        GlobalRadioState globalRadioState = RadioUtil.getGlobalRadioState((class_3218)this.field_11863);
        class_243 center = this.field_11867.method_46558();
        for (class_2338 transmitterPos : globalRadioState.getTransmitters()) {
            HashMap audioInstances;
            TransmitterBlockEntity transmitter;
            if (center.method_1022(transmitterPos.method_46558()) > (double)ConfigManager.config.radioListeningDistance || (transmitter = (TransmitterBlockEntity)this.field_11863.method_8321(transmitterPos)) == null || !transmitter.enabled || (audioInstances = globalRadioState.audioManager.transmitterAudioInstances.computeIfAbsent(transmitterPos, playerEntity -> new HashMap())).containsKey(this.field_11867.method_10062()) && !overrideExisting) continue;
            if (audioInstances.containsKey(this.field_11867.method_10062())) {
                globalRadioState.audioManager.stopTransmitter(transmitterPos, this.field_11867);
            }
            int ticksPlayingFor = (int)(this.field_39482 - this.field_39483);
            int startIndex = 2400 * ticksPlayingFor;
            RadioAudioInstance audioInstance = RadioUtil.transmitDataOnChannel(AnalogPlugin.API, (class_3218)this.field_11863, this.cachedAudio, transmitter.channel);
            audioInstance.setCurrentIndex(startIndex);
            audioInstances.put(this.field_11867.method_10062(), audioInstance);
        }
    }
}

