/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.builder;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_768;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class PanelLayout {
    private final Vector2i pos = new Vector2i();
    private final Vector2i lastPos = new Vector2i();
    private final class_768 bounds = new class_768(0, 0, 0, 0);
    private final int[] padding;
    private final List<class_339> widgets = Lists.newArrayList();

    public PanelLayout(int padding) {
        this(padding, padding, padding, padding);
    }

    public PanelLayout(int left, int top, int right, int bottom) {
        this.padding = new int[]{left, top, right, bottom};
    }

    public void addWidget(class_339 widget) {
        this.widgets.add(widget);
    }

    public void bind(class_437 screen, Vector2i pos, Vector2f anchor) {
        Preconditions.checkArgument((!this.widgets.isEmpty() ? 1 : 0) != 0);
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (class_339 widget : this.widgets) {
            screen.field_33816.add(widget);
            screen.field_22786.add(widget);
            screen.field_33815.add(widget);
            minX = Math.min(minX, widget.method_46426());
            minY = Math.min(minY, widget.method_46427());
            maxX = Math.max(maxX, widget.method_46426() + widget.method_25368());
            maxY = Math.max(maxY, widget.method_46427() + widget.method_25364());
        }
        this.bounds.method_35782(maxX - minX + this.padding[0] + this.padding[2]);
        this.bounds.method_35783(maxY - minY + this.padding[1] + this.padding[3]);
        this.bounds.method_35778(this.bounds.method_3321() - this.padding[0]);
        this.bounds.method_35781(this.bounds.method_3322() - this.padding[1]);
        this.pos.set((Vector2ic)pos);
        this.lastPos.set((int)((float)this.bounds.method_3319() * anchor.x) - this.padding[0], (int)((float)this.bounds.method_3320() * anchor.y) - this.padding[1]);
        this.update();
    }

    public Vector2i getAnchoredPos() {
        return this.pos;
    }

    public void update() {
        int deltaX = this.pos.x - this.lastPos.x;
        int deltaY = this.pos.y - this.lastPos.y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        for (class_339 widget : this.widgets) {
            widget.method_48229(widget.method_46426() + deltaX, widget.method_46427() + deltaY);
        }
        this.lastPos.set((Vector2ic)this.pos);
        this.bounds.method_35778(this.bounds.method_3321() + deltaX);
        this.bounds.method_35781(this.bounds.method_3322() + deltaY);
    }

    public class_768 bounds() {
        return this.bounds;
    }

    public List<class_339> widgets() {
        return this.widgets;
    }
}

