/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createenchantmentindustry.foundation.config;

import com.simibubi.create.foundation.config.ConfigBase;
import fuzs.forgeconfigapiport.api.config.v2.ForgeConfigRegistry;
import fuzs.forgeconfigapiport.api.config.v2.ModConfigEvents;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import plus.dragons.createenchantmentindustry.foundation.config.CeiServerConfig;

public class CeiConfigs {
    public static CeiServerConfig SERVER;
    public static ForgeConfigSpec SERVER_SPEC;
    private static final Map<ModConfig.Type, ConfigBase> CONFIGS;

    public static CeiServerConfig server() {
        return SERVER;
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register() {
        SERVER = CeiConfigs.register(CeiServerConfig::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            ForgeConfigRegistry.INSTANCE.register("create_enchantment_industry", pair.getKey(), (IConfigSpec)pair.getValue().specification);
        }
        ModConfigEvents.loading((String)"create_enchantment_industry").register(CeiConfigs::onLoad);
        ModConfigEvents.reloading((String)"create_enchantment_industry").register(CeiConfigs::onReload);
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    static {
        CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    }
}

