/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.dispatch;

import journeymap.common.network.data.NetworkHandler;
import journeymap.common.network.packets.ClientPermissionsPacket;
import journeymap.common.network.packets.HandshakePacket;
import journeymap.common.network.packets.MultiplayerOptionsPacket;
import journeymap.common.network.packets.ServerAdminRequestPropPacket;
import journeymap.common.network.packets.ServerPlayerLocationPacket;
import journeymap.common.network.packets.WaypointPacket;
import journeymap.common.network.packets.WorldIdPacket;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class NetworkDispatcher {
    protected final NetworkHandler handler;

    public NetworkDispatcher(NetworkHandler handler) {
        this.handler = handler;
    }

    public void sendPlayerLocationPacket(class_3222 player, class_3222 radarPlayer, boolean visible) {
        this.handler.sendToClient(new ServerPlayerLocationPacket((class_1657)radarPlayer, visible), player);
    }

    public void sendClientPermissions(class_3222 player, String payload, boolean serverAdmin) {
        this.handler.sendToClient(new ClientPermissionsPacket(payload, serverAdmin, true), player);
    }

    public void sendWaypointPacket(class_3222 player, String waypoint, boolean announce, String action) {
        this.handler.sendToClient(new WaypointPacket(waypoint, announce, action), player);
    }

    public void sendServerAdminPacket(class_3222 player, int type, String payload, String dimension) {
        this.handler.sendToClient(new ServerAdminRequestPropPacket(type, payload, dimension), player);
    }

    public void sendWorldIdPacket(class_3222 player, String worldId) {
        this.handler.sendToClient(new WorldIdPacket(worldId), player);
    }

    public void sendMultiplayerOptionsPacket(class_3222 player, String payload) {
        this.handler.sendToClient(new MultiplayerOptionsPacket(payload), player);
    }

    public void sendHandshakePacket(class_3222 player, String version) {
        this.handler.sendToClient(new HandshakePacket(version), player);
    }
}

