/*
 * Decompiled with CFR 0.152.
 */
package com.ninni.spawn.entity;

import com.ninni.spawn.SpawnTags;
import com.ninni.spawn.entity.common.DeepLurker;
import com.ninni.spawn.entity.common.FlopConditionable;
import com.ninni.spawn.entity.common.TiltingFishEntity;
import com.ninni.spawn.registry.SpawnCriteriaTriggers;
import com.ninni.spawn.registry.SpawnItems;
import com.ninni.spawn.registry.SpawnParticles;
import com.ninni.spawn.registry.SpawnSoundEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5761;
import org.jetbrains.annotations.Nullable;

public class AnglerFish
extends TiltingFishEntity
implements class_5761,
DeepLurker,
FlopConditionable {
    public static final class_1856 TEMPT_INGREDIENT = class_1856.method_8106(SpawnTags.ANGLER_FISH_TEMPTS);
    public static final String LAST_EFFECT_GIVEN_KEY = "LastEffectGiven";
    public static final int EFFECT_DURATION = 300;
    public static final int EFFECT_DELAY = 330;
    private boolean lastDeflated;
    private long lastDeflationSound;
    private long lastEffectGiven;

    public AnglerFish(class_1299<? extends AnglerFish> type, class_1937 world) {
        super(type, world);
    }

    public boolean isDeflated() {
        return this.method_5669() < this.method_5748() - 4 || !this.method_5805();
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new class_1391((class_1314)this, 1.25, TEMPT_INGREDIENT, false));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            boolean deflated = this.isDeflated();
            if (deflated && !this.lastDeflated) {
                long time = this.method_37908().method_8510();
                if (this.lastDeflationSound == 0L || time - this.lastDeflationSound >= 15L) {
                    this.method_37908().method_43129(null, (class_1297)this, SpawnSoundEvents.ANGLER_FISH_DEFLATE, this.method_5634(), this.method_6107(), this.method_6017());
                    this.lastDeflationSound = time;
                }
            }
            this.lastDeflated = deflated;
        }
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5869() && this.field_6012 % 4 == 0) {
            this.method_37908().method_8406((class_2394)SpawnParticles.ANGLER_FISH_LANTERN_GLOW, this.method_23322(0.15), this.method_23323(1.25), this.method_23325(0.15), 0.0, 0.0, 0.0);
        }
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (!this.method_37908().field_9236 && stack.method_31573(SpawnTags.ANGLER_FISH_LIKES) && !this.isDeflated() && !player.method_6059(class_1294.field_5925)) {
            long time = this.method_37908().method_8510();
            if (this.lastEffectGiven == 0L || time - this.lastEffectGiven > 6600L) {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    SpawnCriteriaTriggers.INTERACT_WITH_ANGLER_FISH.trigger(serverPlayer);
                }
                player.method_6092(new class_1293(class_1294.field_5925, 6000, 0, false, true));
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                this.method_43077(SpawnSoundEvents.ANGLER_FISH_EFFECT_GIVE);
                class_1937 class_19372 = this.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 world = (class_3218)class_19372;
                    world.method_14199((class_2394)SpawnParticles.ANGLER_FISH_LANTERN_GLOW, this.method_23322(0.1f), this.method_23323(0.5), this.method_23325(0.1f), 40, 25.0, 25.0, 25.0, 0.0);
                }
                this.lastEffectGiven = time;
            } else {
                this.method_43077(SpawnSoundEvents.ANGLER_FISH_EFFECT_DENY);
                class_1937 class_19373 = this.method_37908();
                if (class_19373 instanceof class_3218) {
                    class_3218 world = (class_3218)class_19373;
                    world.method_14199((class_2394)SpawnParticles.ANGLER_FISH_LANTERN_GLOW, this.method_23322(0.05f), this.method_23323(0.5), this.method_23325(0.05f), 10, 25.0, 25.0, 25.0, 0.0);
                }
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public boolean doesFlopWhileOutOfWater() {
        int air;
        return air % ((air = this.method_5669()) > 40 ? 15 : 10) + this.field_5974.method_43048(5) == 0 && this.method_5805();
    }

    public float method_6144(class_2338 blockPos, class_4538 levelReader) {
        return this.getLurkingPathfindingFavor(blockPos, levelReader);
    }

    public class_1799 method_6452() {
        return SpawnItems.ANGLER_FISH_BUCKET.method_7854();
    }

    @Nullable
    protected class_3414 method_6002() {
        return SpawnSoundEvents.FISH_DEATH;
    }

    protected class_3414 method_5737() {
        return SpawnSoundEvents.FISH_SWIM;
    }

    @Nullable
    protected class_3414 method_5994() {
        return SpawnSoundEvents.FISH_AMBIENT;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return SpawnSoundEvents.FISH_HURT;
    }

    protected class_3414 method_6457() {
        return SpawnSoundEvents.FISH_FLOP;
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10544(LAST_EFFECT_GIVEN_KEY, this.lastEffectGiven);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.lastEffectGiven = compoundTag.method_10537(LAST_EFFECT_GIVEN_KEY);
    }
}

