/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.components;

import com.google.common.collect.ImmutableList;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.attributes.SlotAttribute;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.UniqueSlotHandling;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.accessories.endec.MinecraftEndecs;
import io.wispforest.accessories.utils.AttributeUtils;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public record AccessoryItemAttributeModifiers(List<Entry> modifiers, boolean showInTooltip) {
    public static final AccessoryItemAttributeModifiers EMPTY = new AccessoryItemAttributeModifiers(List.of(), true);
    public static final Endec<AccessoryItemAttributeModifiers> ENDEC = StructEndecBuilder.of((StructField)Entry.ENDEC.listOf().fieldOf("modifiers", AccessoryItemAttributeModifiers::modifiers), (StructField)Endec.BOOLEAN.optionalFieldOf("show_in_tooltip", AccessoryItemAttributeModifiers::showInTooltip, (Object)true), AccessoryItemAttributeModifiers::new);

    public static Builder builder() {
        return new Builder();
    }

    public boolean hasModifier(class_1320 holder, class_2960 location) {
        return this.getModifier(holder, location) != null;
    }

    @Nullable
    public class_1322 getModifier(class_1320 holder, class_2960 location) {
        for (Entry entry : this.modifiers) {
            class_2960 modifierLocation = AttributeUtils.getLocation(entry.modifier.method_6185());
            if (!entry.attribute.equals(holder) || !modifierLocation.equals((Object)location)) continue;
            return entry.modifier();
        }
        return null;
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(class_1320 holder, class_2960 location, double amount, class_1322.class_1323 operation, String slotName, boolean isStackable) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        return this.withModifierAdded(holder, new class_1322((UUID)data.second(), (String)data.first(), amount, operation), "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(class_1320 holder, class_2960 location, double amount, class_1322.class_1323 operation, String slotName, boolean isStackable) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        return this.withModifierAdded(holder, new class_1322((UUID)data.second(), (String)data.first(), amount, operation), slotName, isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAddedForAny(class_1320 holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
        return this.withModifierAdded(holder, attributeModifier, "any", isStackable);
    }

    public AccessoryItemAttributeModifiers withModifierAdded(class_1320 holder, class_1322 attributeModifier, String slotName, boolean isStackable) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            if (!entry.modifier.method_6189().equals(attributeModifier.method_6189())) {
                builder.add(entry);
            }
        });
        builder.add((Object)new Entry(holder, attributeModifier, slotName, isStackable));
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    public AccessoryItemAttributeModifiers withoutModifier(class_6880<class_1320> holder, class_2960 location) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)(this.modifiers.size() + 1));
        this.modifiers.forEach(entry -> {
            class_2960 modifierLocation = AttributeUtils.getLocation(entry.modifier.method_6185());
            if (modifierLocation.equals((Object)location) && entry.attribute().equals(holder)) {
                return;
            }
            builder.add(entry);
        });
        return new AccessoryItemAttributeModifiers((List<Entry>)builder.build(), this.showInTooltip());
    }

    @ApiStatus.Internal
    public AccessoryAttributeBuilder gatherAttributes(SlotReference slotReference) {
        AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(slotReference);
        if (this.modifiers().isEmpty()) {
            return builder;
        }
        class_1309 entity = slotReference.entity();
        Map slots = entity != null ? SlotTypeLoader.getSlotTypes(entity.method_37908()) : Map.of();
        for (Entry entry : this.modifiers()) {
            class_1322 modifer = entry.modifier();
            String slotTarget = entry.slotName();
            if (!slots.containsKey(slotTarget) && !slotReference.slotName().equals(slotTarget) && !slotTarget.equals("any")) continue;
            if (entry.isStackable()) {
                builder.addStackable(entry.attribute(), AttributeUtils.getLocation(modifer.method_6185()), modifer.method_6186(), modifer.method_6182());
                continue;
            }
            builder.addExclusive(entry.attribute(), AttributeUtils.getLocation(modifer.method_6185()), modifer.method_6186(), modifer.method_6182());
        }
        return builder;
    }

    public static class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();
        private boolean showInTooltip = true;

        private Builder() {
        }

        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="1.22")
        public Builder add(class_1320 attribute, class_1322 attributeModifier, String slotName, boolean isStackable) {
            return this.addForSlot(attribute, attributeModifier, slotName, isStackable);
        }

        public Builder addForSlot(class_1320 attribute, class_1322 attributeModifier, String slotName, boolean isStackable) {
            this.entries.add(new Entry(attribute, attributeModifier, slotName, isStackable));
            return this;
        }

        public Builder addForAny(class_1320 attribute, class_1322 attributeModifier, boolean isStackable) {
            this.entries.add(new Entry(attribute, attributeModifier, "any", isStackable));
            return this;
        }

        public Builder showInTooltip(boolean value) {
            this.showInTooltip = value;
            return this;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public AccessoryItemAttributeModifiers build() {
            return new AccessoryItemAttributeModifiers(Collections.unmodifiableList(this.entries), this.showInTooltip);
        }
    }

    public record Entry(class_1320 attribute, class_1322 modifier, String slotName, boolean isStackable) {
        private static final Endec<class_1320> ATTRIBUTE_ENDEC = MinecraftEndecs.IDENTIFIER.xmapWithContext((context, attributeType) -> {
            if (attributeType.method_12836().equals("accessories")) {
                String path = attributeType.method_12832();
                if (path.contains("/")) {
                    path = path.replace("/", ":");
                }
                return SlotAttribute.getSlotAttribute(path);
            }
            return (class_1320)class_7923.field_41190.method_17966(attributeType).orElseThrow(IllegalStateException::new);
        }, (context, attribute) -> {
            if (attribute instanceof SlotAttribute) {
                SlotAttribute slotAttribute = (SlotAttribute)((Object)attribute);
                String path = slotAttribute.slotName();
                if (UniqueSlotHandling.isUniqueSlot(path)) {
                    path = path.replace(":", "/");
                }
                return Accessories.of(path);
            }
            return class_7923.field_41190.method_10221(attribute);
        });
        public static final Endec<Entry> ENDEC = StructEndecBuilder.of((StructField)ATTRIBUTE_ENDEC.fieldOf("type", Entry::attribute), (StructField)AttributeUtils.ATTRIBUTE_MODIFIER_ENDEC.flatFieldOf(Entry::modifier), (StructField)Endec.STRING.fieldOf("slot_name", Entry::slotName), (StructField)Endec.BOOLEAN.optionalFieldOf("is_stackable", Entry::isStackable, (Object)false), Entry::new);
    }
}

