/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.networking.BaseAccessoriesPacket;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public record AccessoryBreak(int entityId, String slotName, int slotIndex) implements BaseAccessoriesPacket
{
    public static Endec<AccessoryBreak> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", AccessoryBreak::entityId), (StructField)Endec.STRING.fieldOf("slotName", AccessoryBreak::slotName), (StructField)Endec.VAR_INT.fieldOf("slotIndex", AccessoryBreak::slotIndex), AccessoryBreak::new);

    public static AccessoryBreak of(SlotReference slotReference) {
        return new AccessoryBreak(slotReference.entity().method_5628(), slotReference.slotName(), slotReference.slot());
    }

    @Override
    public void handle(class_1657 player) {
        class_1297 entity = player.method_37908().method_8469(this.entityId);
        if (!(entity instanceof class_1309)) {
            throw new IllegalStateException("Unable to handle a Break call due to the passed entity id not corresponding to a LivingEntity!");
        }
        class_1309 livingEntity = (class_1309)entity;
        SlotReference slotReference = SlotReference.of(livingEntity, this.slotName, this.slotIndex);
        AccessoriesCapability capability = livingEntity.accessoriesCapability();
        AccessoriesContainer container = capability.getContainer(slotReference.type());
        class_1799 stack = container.getAccessories().method_5438(slotReference.slot());
        Accessory accessory = AccessoriesAPI.getAccessory(stack);
        if (accessory != null) {
            accessory.onBreak(stack, slotReference);
        }
    }
}

