/*
 * Decompiled with CFR 0.152.
 */
package crab.backport.block;

import crab.backport.block.SideChainPart;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public interface SideChaining {
    public SideChainPart getSideChainPart(class_2680 var1);

    public class_2680 withSideChainPart(class_2680 var1, SideChainPart var2);

    public class_2350 getFacing(class_2680 var1);

    public boolean canChainWith(class_2680 var1);

    public int getMaxSideChainLength();

    default public List<class_2338> getPositionsInChain(class_1936 world, class_2338 pos) {
        class_2680 blockState = world.method_8320(pos);
        if (!this.canChainWith(blockState)) {
            return List.of();
        }
        Neighbors neighbors = this.getNeighbors(world, pos, this.getFacing(blockState));
        LinkedList<class_2338> list = new LinkedList<class_2338>();
        list.add(pos);
        this.forEachNeighborTowards(neighbors::getLeftNeighbor, SideChainPart.LEFT, list::add);
        this.forEachNeighborTowards(neighbors::getRightNeighbor, SideChainPart.RIGHT, list::add);
        return list;
    }

    private void forEachNeighborTowards(IntFunction<Neighbor> neighborGetter, SideChainPart part, Consumer<class_2338> posConsumer) {
        for (int i = 1; i < this.getMaxSideChainLength(); ++i) {
            Neighbor neighbor = neighborGetter.apply(i);
            if (neighbor.isCenterOr(part)) {
                posConsumer.accept(neighbor.pos());
            }
            if (neighbor.isNotCenter()) break;
        }
    }

    default public void disconnectNeighbors(class_1936 world, class_2338 pos, class_2680 state) {
        Neighbors neighbors = this.getNeighbors(world, pos, this.getFacing(state));
        neighbors.getLeftNeighbor().disconnectFromRight();
        neighbors.getRightNeighbor().disconnectFromLeft();
    }

    default public void connectNeighbors(class_1936 world, class_2338 pos, class_2680 state, class_2680 oldState) {
        if (this.canChainWith(state) && !this.isAlreadyConnected(state, oldState)) {
            Neighbors neighbors = this.getNeighbors(world, pos, this.getFacing(state));
            SideChainPart sideChainPart = SideChainPart.UNCONNECTED;
            int i = this.getPositionsInChain(world, neighbors.getLeftNeighbor().pos()).size();
            int j = this.getPositionsInChain(world, neighbors.getRightNeighbor().pos()).size();
            int k = 1;
            if (this.canAddChainLength(i, k)) {
                sideChainPart = sideChainPart.connectToLeft();
                neighbors.getLeftNeighbor().connectToRight();
                k += i;
            }
            if (this.canAddChainLength(j, k)) {
                sideChainPart = sideChainPart.connectToRight();
                neighbors.getRightNeighbor().connectToLeft();
            }
            this.setSideChainPart(world, pos, sideChainPart);
        }
    }

    private boolean canAddChainLength(int chainLength, int toAdd) {
        return chainLength > 0 && toAdd + chainLength <= this.getMaxSideChainLength();
    }

    private boolean isAlreadyConnected(class_2680 state, class_2680 oldState) {
        boolean bl = this.getSideChainPart(state).isConnected();
        boolean bl2 = this.canChainWith(oldState) && this.getSideChainPart(oldState).isConnected();
        return bl || bl2;
    }

    private Neighbors getNeighbors(class_1936 world, class_2338 pos, class_2350 facing) {
        return new Neighbors(this, world, facing, pos, new HashMap<class_2338, Neighbor>());
    }

    default public void setSideChainPart(class_1936 world, class_2338 pos, SideChainPart part) {
        class_2680 blockState = world.method_8320(pos);
        if (this.getSideChainPart(blockState) != part) {
            world.method_8652(pos, this.withSideChainPart(blockState, part), 3);
        }
    }

    public record Neighbors(SideChaining block, class_1936 world, class_2350 facing, class_2338 center, Map<class_2338, Neighbor> cache) {
        private boolean canChainWith(class_2680 state) {
            return this.block.canChainWith(state) && this.block.getFacing(state) == this.facing;
        }

        private Neighbor createNeighbor(class_2338 pos) {
            class_2680 blockState = this.world.method_8320(pos);
            SideChainPart sideChainPart = this.canChainWith(blockState) ? this.block.getSideChainPart(blockState) : null;
            return (Neighbor)((Object)(sideChainPart == null ? new EmptyNeighbor(pos) : new SideChainNeighbor(this.world, this.block, pos, sideChainPart)));
        }

        private Neighbor getOrCreateNeighbor(class_2350 direction, Integer distance) {
            return this.cache.computeIfAbsent(this.center.method_10079(direction, distance.intValue()), this::createNeighbor);
        }

        public Neighbor getLeftNeighbor(int distance) {
            return this.getOrCreateNeighbor(this.facing.method_10170(), distance);
        }

        public Neighbor getRightNeighbor(int distance) {
            return this.getOrCreateNeighbor(this.facing.method_10160(), distance);
        }

        public Neighbor getLeftNeighbor() {
            return this.getLeftNeighbor(1);
        }

        public Neighbor getRightNeighbor() {
            return this.getRightNeighbor(1);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Neighbor {
        public class_2338 pos();

        public boolean isNotCenter();

        public boolean isCenterOr(SideChainPart var1);

        default public void connectToRight() {
        }

        default public void connectToLeft() {
        }

        default public void disconnectFromRight() {
        }

        default public void disconnectFromLeft() {
        }
    }

    public record SideChainNeighbor(class_1936 level, SideChaining block, class_2338 pos, SideChainPart part) implements Neighbor
    {
        @Override
        public boolean isNotCenter() {
            return this.part.isNotCenter();
        }

        @Override
        public boolean isCenterOr(SideChainPart part) {
            return this.part.isCenterOr(part);
        }

        @Override
        public void connectToRight() {
            this.block.setSideChainPart(this.level, this.pos, this.part.connectToRight());
        }

        @Override
        public void connectToLeft() {
            this.block.setSideChainPart(this.level, this.pos, this.part.connectToLeft());
        }

        @Override
        public void disconnectFromRight() {
            this.block.setSideChainPart(this.level, this.pos, this.part.disconnectFromRight());
        }

        @Override
        public void disconnectFromLeft() {
            this.block.setSideChainPart(this.level, this.pos, this.part.disconnectFromLeft());
        }
    }

    public record EmptyNeighbor(class_2338 pos) implements Neighbor
    {
        @Override
        public boolean isNotCenter() {
            return true;
        }

        @Override
        public boolean isCenterOr(SideChainPart part) {
            return false;
        }
    }
}

