/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.pneumono.pneumonocore.PneumonoCore;
import net.pneumono.pneumonocore.config_api.ClientConfigApi;
import net.pneumono.pneumonocore.config_api.ClientConfigCommandRegistry;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigFile;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BooleanConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BoundedFloatConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.BoundedIntegerConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigManager;
import net.pneumono.pneumonocore.config_api.configurations.EnumConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.FloatConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.IntegerConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.StringConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.TimeConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ValidatedStringConfiguration;
import net.pneumono.pneumonocore.config_api.registry.ConfigApiRegistry;
import net.pneumono.pneumonocore.config_api.screen.entries.BooleanConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.BoundedFloatConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.BoundedIntegerConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.EnumConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.FloatConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.IntegerConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.StringConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.TimeConfigurationEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.ValidatedStringConfigurationEntry;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigApiRegistry {
    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ConfigApiRegistry.CONFIG_SYNC_ID, ClientConfigApiRegistry::receiveSyncPacket);
        ClientConfigCommandRegistry.registerClientConfigCommand();
        ClientConfigApiRegistry.registerConfigEntryType("boolean", (parent, widget, configuration) -> {
            BooleanConfigurationEntry booleanConfigurationEntry;
            if (configuration instanceof BooleanConfiguration) {
                BooleanConfiguration booleanConfiguration = (BooleanConfiguration)configuration;
                booleanConfigurationEntry = new BooleanConfigurationEntry(parent, widget, booleanConfiguration);
            } else {
                booleanConfigurationEntry = null;
            }
            return booleanConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("enum", (parent, widget, configuration) -> {
            EnumConfigurationEntry enumConfigurationEntry;
            if (configuration instanceof EnumConfiguration) {
                EnumConfiguration enumConfiguration = (EnumConfiguration)configuration;
                enumConfigurationEntry = new EnumConfigurationEntry(parent, widget, enumConfiguration);
            } else {
                enumConfigurationEntry = null;
            }
            return enumConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("integer", (parent, widget, configuration) -> {
            IntegerConfigurationEntry integerConfigurationEntry;
            if (configuration instanceof IntegerConfiguration) {
                IntegerConfiguration integerConfiguration = (IntegerConfiguration)configuration;
                integerConfigurationEntry = new IntegerConfigurationEntry(parent, widget, integerConfiguration);
            } else {
                integerConfigurationEntry = null;
            }
            return integerConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("bounded_integer", (parent, widget, configuration) -> {
            BoundedIntegerConfigurationEntry boundedIntegerConfigurationEntry;
            if (configuration instanceof BoundedIntegerConfiguration) {
                BoundedIntegerConfiguration boundedIntegerConfiguration = (BoundedIntegerConfiguration)configuration;
                boundedIntegerConfigurationEntry = new BoundedIntegerConfigurationEntry(parent, widget, boundedIntegerConfiguration);
            } else {
                boundedIntegerConfigurationEntry = null;
            }
            return boundedIntegerConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("float", (parent, widget, configuration) -> {
            FloatConfigurationEntry floatConfigurationEntry;
            if (configuration instanceof FloatConfiguration) {
                FloatConfiguration floatConfiguration = (FloatConfiguration)configuration;
                floatConfigurationEntry = new FloatConfigurationEntry(parent, widget, floatConfiguration);
            } else {
                floatConfigurationEntry = null;
            }
            return floatConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("bounded_float", (parent, widget, configuration) -> {
            BoundedFloatConfigurationEntry boundedFloatConfigurationEntry;
            if (configuration instanceof BoundedFloatConfiguration) {
                BoundedFloatConfiguration boundedFloatConfiguration = (BoundedFloatConfiguration)configuration;
                boundedFloatConfigurationEntry = new BoundedFloatConfigurationEntry(parent, widget, boundedFloatConfiguration);
            } else {
                boundedFloatConfigurationEntry = null;
            }
            return boundedFloatConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("string", (parent, widget, configuration) -> {
            StringConfigurationEntry stringConfigurationEntry;
            if (configuration instanceof StringConfiguration) {
                StringConfiguration stringConfiguration = (StringConfiguration)configuration;
                stringConfigurationEntry = new StringConfigurationEntry(parent, widget, stringConfiguration);
            } else {
                stringConfigurationEntry = null;
            }
            return stringConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("validated_string", (parent, widget, configuration) -> {
            ValidatedStringConfigurationEntry validatedStringConfigurationEntry;
            if (configuration instanceof ValidatedStringConfiguration) {
                ValidatedStringConfiguration validatedStringConfiguration = (ValidatedStringConfiguration)configuration;
                validatedStringConfigurationEntry = new ValidatedStringConfigurationEntry(parent, widget, validatedStringConfiguration);
            } else {
                validatedStringConfigurationEntry = null;
            }
            return validatedStringConfigurationEntry;
        });
        ClientConfigApiRegistry.registerConfigEntryType("time", (parent, widget, configuration) -> {
            TimeConfigurationEntry timeConfigurationEntry;
            if (configuration instanceof TimeConfiguration) {
                TimeConfiguration timeConfiguration = (TimeConfiguration)configuration;
                timeConfigurationEntry = new TimeConfigurationEntry(parent, widget, timeConfiguration);
            } else {
                timeConfigurationEntry = null;
            }
            return timeConfigurationEntry;
        });
    }

    private static void registerConfigEntryType(String name, ClientConfigApi.EntryFactory selector) {
        ClientConfigApi.registerConfigEntryType(PneumonoCore.identifier(name), selector);
    }

    public static void receiveSyncPacket(class_310 client, class_634 handler, class_2540 buf, PacketSender responseSender) {
        ClientConfigApiRegistry.receiveSyncPacket(buf.method_10798());
    }

    public static void receiveSyncPacket(class_2487 nbt) {
        ConfigApi.LOGGER.info("Received config sync packet");
        for (ConfigFile configFile : ConfigApi.getConfigFiles()) {
            class_2487 compound = MultiVersionUtil.getCompound(nbt, configFile.getModId());
            if (compound == null || compound.method_33133()) continue;
            for (AbstractConfiguration<?> configuration : configFile.getConfigurations()) {
                class_2520 element = compound.method_10580(configuration.info().getName());
                if (element == null || ClientConfigApiRegistry.setReceivedEffectiveValue(configuration, element)) continue;
                ConfigApi.LOGGER.warn("Config sync packet contains invalid value '{}' for config '{}'. The default config value will be used instead.", (Object)element, (Object)configuration.info().getId());
            }
        }
    }

    private static <T> boolean setReceivedEffectiveValue(AbstractConfiguration<T> config, class_2520 nbtElement) {
        DataResult result = config.getValueCodec().decode((DynamicOps)class_2509.field_11560, (Object)nbtElement);
        if (MultiVersionUtil.resultIsError(result)) {
            return false;
        }
        ConfigManager.setEffectiveValue(config, ((Pair)MultiVersionUtil.resultGetOrThrow(result)).getFirst());
        return true;
    }
}

