/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigFile;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigManager;

@Environment(value=EnvType.CLIENT)
public final class ClientConfigCommandRegistry {
    public static void registerClientConfigCommand() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"clientconfig").then(ClientCommandManager.literal((String)"get").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"modid", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ModIdSuggestionProvider()).then(ClientCommandManager.argument((String)"config", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ConfigSuggestionProvider()).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)ClientConfigCommandRegistry.getConfigValueString(StringArgumentType.getString((CommandContext)context, (String)"modid"), StringArgumentType.getString((CommandContext)context, (String)"config"))).method_27692(class_124.field_1075));
            return 1;
        }))).executes(context -> {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"Configs:"));
            List<String> configs = ClientConfigCommandRegistry.getAllConfigValueStrings(StringArgumentType.getString((CommandContext)context, (String)"modid"));
            if (configs.isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"   None!"));
            } else {
                for (String config : configs) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("   " + config)));
                }
            }
            return 1;
        })))));
    }

    public static List<String> getAllConfigValueStrings(String modId) {
        ArrayList<String> returnConfigs = new ArrayList<String>();
        ConfigFile modConfigs = ConfigApi.getConfigFile(modId);
        if (modConfigs != null) {
            for (AbstractConfiguration<?> config : modConfigs.getConfigurations()) {
                String valueString = config.info().isClientSided() ? config.getValue().toString() : ConfigManager.getSavedValue(config).toString();
                returnConfigs.add(config.info().getModId() + ":" + config.info().getName() + " is set to " + valueString);
            }
        }
        return returnConfigs;
    }

    public static String getConfigValueString(String modId, String name) {
        AbstractConfiguration<?> config;
        ConfigFile modConfigs = ConfigApi.getConfigFile(modId);
        if (modConfigs != null && (config = modConfigs.getConfiguration(name)) != null) {
            String valueString = config.info().isClientSided() ? config.getValue().toString() : ConfigManager.getSavedValue(config).toString();
            return config.info().getModId() + ":" + config.info().getName() + " is set to " + valueString;
        }
        return modId + ":" + name + " does not exist!";
    }

    @Environment(value=EnvType.CLIENT)
    public static class ModIdSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
            for (ConfigFile modConfigs : ConfigApi.getConfigFiles()) {
                if (!modConfigs.getModId().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                builder.suggest(modConfigs.getModId());
            }
            return builder.buildFuture();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigSuggestionProvider
    implements SuggestionProvider<FabricClientCommandSource> {
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
            ConfigFile modConfigs = ConfigApi.getConfigFile(StringArgumentType.getString(context, (String)"modid"));
            if (modConfigs != null) {
                for (AbstractConfiguration<?> config : modConfigs.getConfigurations()) {
                    if (!config.info().getName().toLowerCase().startsWith(builder.getRemainingLowerCase())) continue;
                    builder.suggest(config.info().getName());
                }
            }
            return builder.buildFuture();
        }
    }
}

