/*
 * Decompiled with CFR 0.152.
 */
package net.pneumono.pneumonocore.config_api.screen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_437;
import net.pneumono.pneumonocore.config_api.ConfigApi;
import net.pneumono.pneumonocore.config_api.ConfigFile;
import net.pneumono.pneumonocore.config_api.configurations.AbstractConfiguration;
import net.pneumono.pneumonocore.config_api.configurations.ConfigManager;
import net.pneumono.pneumonocore.config_api.enums.LoadType;
import net.pneumono.pneumonocore.config_api.screen.ConfigOptionsScreen;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigListWidgetEntry;
import net.pneumono.pneumonocore.config_api.screen.entries.AbstractConfigurationEntry;
import net.pneumono.pneumonocore.util.MultiVersionUtil;

@Environment(value=EnvType.CLIENT)
public class ClientConfigOptionsScreen
extends ConfigOptionsScreen {
    public ClientConfigOptionsScreen(class_437 parent, String modId) {
        super(parent, modId);
    }

    @Override
    public <T> T getConfigValue(AbstractConfiguration<T> configuration) {
        return ConfigManager.getSavedValue(configuration);
    }

    @Override
    public <T, C extends AbstractConfiguration<T>> void setSavedValue(AbstractConfigurationEntry<T, C> entry) {
        C config = entry.getConfiguration();
        T value = entry.getValue();
        ConfigManager.setSavedValue(config, value);
        if (((AbstractConfiguration)config).info().isClientSided() && LoadType.INSTANT.canLoad(((AbstractConfiguration)config).info().getLoadType())) {
            ConfigManager.setEffectiveValue(config, value);
        }
    }

    @Override
    public void writeSavedValues() {
        ConfigFile configFile = this.configsListWidget.configFile;
        if (configFile == null) {
            return;
        }
        JsonObject jsonObject = new JsonObject();
        for (AbstractConfigListWidgetEntry entry : this.configsListWidget.getEntries()) {
            AbstractConfigurationEntry configEntry;
            JsonElement jsonElement;
            if (!(entry instanceof AbstractConfigurationEntry) || (jsonElement = ClientConfigOptionsScreen.encodeJson(configEntry = (AbstractConfigurationEntry)entry)) == null) continue;
            jsonObject.add(((AbstractConfiguration)configEntry.getConfiguration()).info().getName(), jsonElement);
        }
        configFile.writeObjectToFile(jsonObject);
    }

    private static <T, C extends AbstractConfiguration<T>> JsonElement encodeJson(AbstractConfigurationEntry<T, C> entry) {
        DataResult result = ((AbstractConfiguration)entry.getConfiguration()).getValueCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, entry.getValue());
        if (MultiVersionUtil.resultIsError(result)) {
            ConfigApi.LOGGER.error("Could not encode value for config '{}'.", (Object)((AbstractConfiguration)entry.getConfiguration()).info().getId());
            return null;
        }
        return (JsonElement)result.getOrThrow(false, message -> {
            throw new IllegalStateException("Could not encode value for config '" + String.valueOf(((AbstractConfiguration)entry.getConfiguration()).info().getId()) + "'");
        });
    }
}

