/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.block_hit_effects;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.simibubi.create.foundation.utility.BlockHelper;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import rbasamoyai.createbigcannons.base.PropertySetter;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class BlockTransformation {
    private static final Transform NO_TRANSFORM = new Transform(){

        @Override
        public class_2680 apply(class_2680 blockState) {
            return blockState;
        }
    };
    private final Map<Transform, Float> weightedTransforms;
    private final float weightSum;
    private final float chance;

    public BlockTransformation(Map<Transform, Float> weightedTransforms, float chance) {
        this.weightedTransforms = weightedTransforms;
        float sum = 0.0f;
        for (Float f : this.weightedTransforms.values()) {
            sum += f.floatValue();
        }
        this.weightSum = sum;
        this.chance = chance;
    }

    public class_2680 transformBlock(class_2680 inputBlockState) {
        if (Math.random() > (double)this.chance) {
            return inputBlockState;
        }
        float sum = this.weightSum;
        Transform transform = NO_TRANSFORM;
        for (Map.Entry<Transform, Float> entry : this.weightedTransforms.entrySet()) {
            float weight = entry.getValue().floatValue();
            if (Math.random() * (double)sum <= (double)weight) {
                transform = entry.getKey();
                break;
            }
            sum -= weight;
        }
        return (class_2680)transform.apply(inputBlockState);
    }

    public static BlockTransformation fromJson(JsonObject obj) throws JsonParseException {
        JsonArray array = class_3518.method_15261((JsonObject)obj, (String)"transforms");
        Object2ObjectLinkedOpenHashMap weightedTransforms = new Object2ObjectLinkedOpenHashMap();
        for (JsonElement el : array) {
            JsonObject transformObj = el.getAsJsonObject();
            Transform transform = Transform.optionalFromJson(class_3518.method_15296((JsonObject)transformObj, (String)"transform"));
            float weight = class_3518.method_15277((JsonObject)transformObj, (String)"weight", (float)1.0f);
            weightedTransforms.put(transform, Float.valueOf(weight));
        }
        float chance = class_3532.method_15363((float)class_3518.method_15277((JsonObject)obj, (String)"transform_chance", (float)1.0f), (float)0.0f, (float)1.0f);
        return new BlockTransformation((Map<Transform, Float>)weightedTransforms, chance);
    }

    public static interface Transform
    extends UnaryOperator<class_2680> {
        private static Transform optionalFromJson(JsonObject obj) throws JsonParseException {
            String id = class_3518.method_15265((JsonObject)obj, (String)"block");
            class_2960 blockLocation = CBCUtils.location(id);
            Optional<class_2248> optional = CBCRegistryUtils.getOptionalBlock(blockLocation);
            if (optional.isEmpty()) {
                return NO_TRANSFORM;
            }
            class_2248 block = optional.get();
            boolean copy = class_3518.method_15258((JsonObject)obj, (String)"copy_properties", (boolean)false);
            ArrayList propertySetters = new ArrayList();
            JsonArray arr = class_3518.method_15292((JsonObject)obj, (String)"properties", (JsonArray)new JsonArray());
            class_2689 definition = block.method_9595();
            for (JsonElement el : arr) {
                JsonObject setterObj = el.getAsJsonObject();
                String propertyName = class_3518.method_15265((JsonObject)setterObj, (String)"property");
                class_2769 property = definition.method_11663(propertyName);
                if (property == null) {
                    throw new JsonParseException("Block " + blockLocation + " does not have property \"" + propertyName + "\"");
                }
                String value = class_3518.method_15265((JsonObject)setterObj, (String)"value");
                PropertySetter setter = Transform.getSetterHelper(property, value);
                propertySetters.add(setter);
            }
            return new Impl(block, propertySetters, copy);
        }

        private static <T extends Comparable<T>> PropertySetter<T> getSetterHelper(class_2769<T> property, String value) {
            Optional optional = property.method_11900(value);
            if (optional.isEmpty()) {
                throw new JsonParseException("Unable to read property: %s with value: %s".formatted(property, value));
            }
            return PropertySetter.of(property, (Comparable)optional.get());
        }

        public record Impl(class_2248 base, List<PropertySetter<?>> propertySetters, boolean copyProperties) implements Transform
        {
            @Override
            public class_2680 apply(class_2680 inputBlockState) {
                class_2680 outputState = this.base.method_9564();
                if (this.copyProperties) {
                    outputState = BlockHelper.copyProperties((class_2680)inputBlockState, (class_2680)outputState);
                }
                for (PropertySetter<?> setter : this.propertySetters) {
                    outputState = setter.applyTo(outputState);
                }
                return outputState;
            }
        }
    }
}

