/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.crafting.casting;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.class_2540;
import net.minecraft.class_2547;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import rbasamoyai.createbigcannons.base.tag_utils.FluidTypeDataHolder;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class FluidCastingTimeHandler {
    private static final FluidTypeDataHolder<Integer> CASTING_TIME = new FluidTypeDataHolder();

    public static void clear() {
        CASTING_TIME.cleanUp();
    }

    public static void loadTags() {
        CASTING_TIME.loadTags();
    }

    public static int getCastingTime(class_3611 fluid) {
        Integer castingTime = CASTING_TIME.getData(fluid);
        return castingTime == null ? 1000 : castingTime;
    }

    public static void writeBuf(class_2540 buf) {
        CASTING_TIME.writeToNetwork(buf, class_2540::method_10804);
    }

    public static void readBuf(class_2540 buf) {
        CASTING_TIME.readFromNetwork(buf, class_2540::method_10816);
    }

    public static void syncTo(class_3222 player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundFluidCastingTimePacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundFluidCastingTimePacket(), server);
    }

    public record ClientboundFluidCastingTimePacket(@Nullable class_2540 buf) implements RootPacket
    {
        public ClientboundFluidCastingTimePacket() {
            this(null);
        }

        public static ClientboundFluidCastingTimePacket copyOf(class_2540 buf) {
            return new ClientboundFluidCastingTimePacket(new class_2540(buf.copy()));
        }

        @Override
        public void rootEncode(class_2540 buf) {
            FluidCastingTimeHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, class_2547 listener, @Nullable class_3222 sender) {
            if (this.buf != null) {
                FluidCastingTimeHandler.readBuf(this.buf);
            }
        }
    }

    public static class ReloadListener
    extends class_4309 {
        private static final Gson GSON = new Gson();
        public static final ReloadListener INSTANCE = new ReloadListener();

        public ReloadListener() {
            super(GSON, "fluid_casting_time");
        }

        protected void apply(Map<class_2960, JsonElement> map, class_3300 resources, class_3695 profiler) {
            FluidCastingTimeHandler.clear();
            for (Map.Entry<class_2960, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                JsonObject obj = el.getAsJsonObject();
                int castingTime = class_3518.method_15282((JsonObject)obj, (String)"casting_time", (int)1000);
                castingTime = Math.max(castingTime, 0);
                class_2960 loc = entry.getKey();
                if (loc.method_12832().startsWith("tags/")) {
                    class_6862 tag = class_6862.method_40092(CBCRegistryUtils.getFluidRegistryKey(), (class_2960)CBCUtils.location(loc.method_12836(), loc.method_12832().substring(5)));
                    CASTING_TIME.addTagData(tag, castingTime);
                    continue;
                }
                class_3611 fluid = CBCRegistryUtils.getOptionalFluid(loc).orElseThrow(() -> new JsonSyntaxException("Unknown fluid type '" + loc + "'"));
                CASTING_TIME.addData(fluid, castingTime);
            }
        }
    }
}

