/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.frozenblock.lib.cape.client.impl.ClientCapeData;
import net.frozenblock.lib.entrypoint.api.FrozenClientEntrypoint;
import net.frozenblock.lib.integration.api.ModIntegrations;
import net.frozenblock.lib.menu.api.Panoramas;
import net.frozenblock.lib.networking.FrozenClientNetworking;
import net.frozenblock.lib.particle.api.FrozenParticleTypes;
import net.frozenblock.lib.particle.impl.DebugPosParticle;
import net.frozenblock.lib.registry.api.client.FrozenClientRegistry;
import net.frozenblock.lib.screenshake.api.client.ScreenShaker;
import net.frozenblock.lib.sound.api.FlyBySoundHub;
import net.frozenblock.lib.sound.impl.block_sound_group.BlockSoundGroupManager;
import net.frozenblock.lib.wind.api.ClientWindManager;
import net.minecraft.class_2396;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import org.quiltmc.qsl.frozenblock.core.registry.impl.sync.client.ClientRegistrySync;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.impl.client.ClientFreezer;

public final class FrozenClient
implements ClientModInitializer {
    public void onInitializeClient() {
        FrozenClientRegistry.initRegistry();
        ModIntegrations.initializePreFreeze();
        ClientFreezer.onInitializeClient();
        ClientRegistrySync.registerHandlers();
        FrozenClient.registerClientEvents();
        FrozenClientNetworking.registerClientReceivers();
        ParticleFactoryRegistry particleRegistry = ParticleFactoryRegistry.getInstance();
        particleRegistry.register((class_2396)FrozenParticleTypes.DEBUG_POS, DebugPosParticle.Provider::new);
        Panoramas.addPanorama(new class_2960("textures/gui/title/background/panorama"));
        ClientCapeData.init();
        ResourceManagerHelper resourceLoader = ResourceManagerHelper.get((class_3264)class_3264.field_14188);
        resourceLoader.registerReloadListener((IdentifiableResourceReloadListener)BlockSoundGroupManager.INSTANCE);
        ((FrozenClientEntrypoint)FrozenClientEntrypoint.EVENT.invoker()).init();
    }

    private static void registerClientEvents() {
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            ClientWindManager.tick(world);
            ScreenShaker.tick(world);
            FlyBySoundHub.update(class_310.method_1551(), class_310.method_1551().method_1560(), true);
        });
        ClientTickEvents.START_CLIENT_TICK.register(client -> ClientWindManager.clearAndSwitchWindDisturbances());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            ScreenShaker.clear();
            ClientWindManager.clearAllWindDisturbances();
        });
    }
}

