/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.sound.api.predicate;

import java.util.function.Supplier;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.registry.api.FrozenRegistry;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public final class SoundPredicate<T extends class_1297> {
    public static final class_2960 DEFAULT_ID = FrozenSharedConstants.id("default");
    public static final class_2960 NOT_SILENT_AND_ALIVE_ID = FrozenSharedConstants.id("not_silent_and_alive");
    private final Supplier<LoopPredicate<T>> predicateSupplier;

    public static <T extends class_1297> void register(class_2960 id, Supplier<LoopPredicate<T>> predicateSupplier) {
        class_2378.method_10230(FrozenRegistry.SOUND_PREDICATE, (class_2960)id, new SoundPredicate<T>(predicateSupplier));
    }

    public static <T extends class_1297> void registerUnsynced(class_2960 id, Supplier<LoopPredicate<T>> predicateSupplier) {
        class_2378.method_10230(FrozenRegistry.SOUND_PREDICATE_UNSYNCED, (class_2960)id, new SoundPredicate<T>(predicateSupplier));
    }

    public SoundPredicate(Supplier<LoopPredicate<T>> predicateSupplier) {
        this.predicateSupplier = predicateSupplier;
    }

    public static <T extends class_1297> LoopPredicate<T> getPredicate(@Nullable class_2960 id) {
        if (id != null) {
            SoundPredicate predicate;
            if (FrozenRegistry.SOUND_PREDICATE.method_10250(id)) {
                SoundPredicate predicate2 = (SoundPredicate)FrozenRegistry.SOUND_PREDICATE.method_10223(id);
                if (predicate2 != null) {
                    return predicate2.predicateSupplier.get();
                }
            } else if (FrozenRegistry.SOUND_PREDICATE_UNSYNCED.method_10250(id) && (predicate = (SoundPredicate)FrozenRegistry.SOUND_PREDICATE_UNSYNCED.method_10223(id)) != null) {
                return predicate.predicateSupplier.get();
            }
            FrozenSharedConstants.LOGGER.error("Unable to find sound predicate " + String.valueOf(id) + "! Using default sound predicate instead!");
        }
        return SoundPredicate.defaultPredicate();
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends class_1297> LoopPredicate<T> defaultPredicate() {
        return entity -> !entity.method_5701();
    }

    @Contract(pure=true)
    @NotNull
    public static <T extends class_1297> LoopPredicate<T> notSilentAndAlive() {
        return entity -> !entity.method_5701();
    }

    public static void init() {
        SoundPredicate.register(DEFAULT_ID, SoundPredicate::defaultPredicate);
        SoundPredicate.register(NOT_SILENT_AND_ALIVE_ID, SoundPredicate::notSilentAndAlive);
    }

    @FunctionalInterface
    public static interface LoopPredicate<T extends class_1297> {
        public boolean test(T var1);

        @Nullable
        default public Boolean firstTickTest(T entity) {
            return null;
        }

        default public void onStart(@Nullable T entity) {
        }

        default public void onStop(@Nullable T entity) {
        }
    }
}

