/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.lib.wind.api;

import java.util.Optional;
import net.frozenblock.lib.FrozenSharedConstants;
import net.frozenblock.lib.registry.api.FrozenRegistry;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.Contract;
import net.frozenblock.lib.shadow.org.jetbrains.annotations.NotNull;
import net.frozenblock.lib.wind.api.WindDisturbance;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;

public final class WindDisturbanceLogic<T> {
    public static final class_2960 DEFAULT_ID = FrozenSharedConstants.id("default");
    private final DisturbanceLogic<T> disturbanceLogic;

    public WindDisturbanceLogic(DisturbanceLogic<T> disturbanceLogic) {
        this.disturbanceLogic = disturbanceLogic;
    }

    public DisturbanceLogic getLogic() {
        return this.disturbanceLogic;
    }

    public static Optional<WindDisturbanceLogic<?>> getWindDisturbanceLogic(class_2960 id) {
        if (id != null) {
            WindDisturbanceLogic disturbanceLogic;
            if (FrozenRegistry.WIND_DISTURBANCE_LOGIC.method_10250(id)) {
                WindDisturbanceLogic disturbanceLogic2 = (WindDisturbanceLogic)FrozenRegistry.WIND_DISTURBANCE_LOGIC.method_10223(id);
                if (disturbanceLogic2 != null) {
                    return Optional.of(disturbanceLogic2);
                }
            } else if (FrozenRegistry.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10250(id) && (disturbanceLogic = (WindDisturbanceLogic)FrozenRegistry.WIND_DISTURBANCE_LOGIC_UNSYNCED.method_10223(id)) != null) {
                return Optional.of(disturbanceLogic);
            }
            FrozenSharedConstants.LOGGER.error("Unable to find wind disturbance logic {}!", (Object)id);
        }
        return Optional.empty();
    }

    @NotNull
    @Contract(pure=true)
    public static DisturbanceLogic<?> defaultPredicate() {
        return (source, level, windOrigin, affectedArea, windTarget) -> WindDisturbance.DUMMY_RESULT;
    }

    public static void init() {
        WindDisturbanceLogic.register(DEFAULT_ID, WindDisturbanceLogic.defaultPredicate());
    }

    public static <T> void register(class_2960 id, DisturbanceLogic<T> predicate) {
        class_2378.method_10230(FrozenRegistry.WIND_DISTURBANCE_LOGIC, (class_2960)id, new WindDisturbanceLogic<T>(predicate));
    }

    public static <T> void registerUnsynced(class_2960 id, DisturbanceLogic<T> predicate) {
        class_2378.method_10230(FrozenRegistry.WIND_DISTURBANCE_LOGIC_UNSYNCED, (class_2960)id, new WindDisturbanceLogic<T>(predicate));
    }

    @FunctionalInterface
    public static interface DisturbanceLogic<T> {
        public WindDisturbance.DisturbanceResult calculateDisturbanceResult(Optional<T> var1, class_1937 var2, class_243 var3, class_238 var4, class_243 var5);
    }

    public static enum SourceType {
        ENTITY,
        BLOCK_ENTITY,
        NONE;

    }
}

