/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer.mixin;

import com.google.gson.JsonObject;
import com.llamalad7.mixinextras.sugar.Local;
import dev.emi.trinkets.api.TrinketEnums;
import dev.emi.trinkets.compat.WrappingTrinketsUtils;
import dev.emi.trinkets.data.SlotLoader;
import io.wispforest.accessories.data.SlotTypeLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SlotTypeLoader.class})
public abstract class SlotTypeLoaderMixin {
    @Unique
    private final class_2960 EMPTY_TEXTURE = new class_2960("trinkets", "gui/slots/empty.png");

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="INVOKE", target="Ljava/util/HashMap;<init>()V", shift=At.Shift.AFTER, ordinal=2)})
    private void injectTrinketSpecificSlots(Map<class_2960, JsonObject> data, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci, @Local(name={"builders"}) HashMap<String, SlotTypeLoader.SlotBuilder> builders) {
        for (Map.Entry<String, SlotLoader.GroupData> groupDataEntry : SlotLoader.INSTANCE.getSlots().entrySet()) {
            SlotLoader.GroupData groupData = groupDataEntry.getValue();
            Map<String, SlotLoader.SlotData> slots = groupData.slots;
            for (Map.Entry<String, SlotLoader.SlotData> entry : slots.entrySet()) {
                SlotTypeLoader.SlotBuilder builder;
                String accessoryType = WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(groupDataEntry.getKey()), entry.getKey());
                SlotLoader.SlotData slotData = entry.getValue();
                if (builders.containsKey(accessoryType)) {
                    builder = builders.get(accessoryType);
                    Integer slotsCurrentSize = builder.baseAmount;
                    if (slotsCurrentSize != null && slotData.amount > slotsCurrentSize) {
                        builder.amount(slotData.amount);
                    }
                } else {
                    builder = new SlotTypeLoader.SlotBuilder(accessoryType);
                    if (slotData.amount != -1) {
                        builder.amount(slotData.amount);
                    }
                    builder.order(Integer.valueOf(slotData.order));
                    class_2960 icon = class_2960.method_12829((String)slotData.icon);
                    if (!this.EMPTY_TEXTURE.equals((Object)icon)) {
                        builder.icon(icon);
                    }
                    builder.dropRule(TrinketEnums.convert(TrinketEnums.DropRule.valueOf(slotData.dropRule)));
                    builder.alternativeTranslation("trinkets.slot." + groupDataEntry.getKey() + "." + entry.getKey());
                    builders.put(accessoryType, builder);
                }
                for (String validatorPredicate : slotData.validatorPredicates) {
                    class_2960 location = class_2960.method_12829((String)validatorPredicate);
                    if (location == null) continue;
                    builder.validator(WrappingTrinketsUtils.trinketsToAccessories_Validators(location));
                }
            }
        }
    }
}

