/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.orientation.IOrientationStrategy;
import appeng.api.orientation.OrientationStrategies;
import appeng.api.orientation.RelativeSide;
import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.misc.CrankBlockEntity;
import java.util.Arrays;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class CrankBlock
extends AEBaseEntityBlock<CrankBlockEntity> {
    private static final class_265[] SHAPES = (class_265[])Arrays.stream(class_2350.values()).map(CrankBlock::createShape).toArray(class_265[]::new);

    public CrankBlock(class_4970.class_2251 props) {
        super(props);
    }

    @Override
    public class_1269 onActivated(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, @Nullable class_1799 heldItem, class_3965 hit) {
        if (player instanceof FakePlayer || player == null) {
            this.dropCrank(level, pos);
            return class_1269.method_29236((boolean)level.method_8608());
        }
        CrankBlockEntity crank = (CrankBlockEntity)this.getBlockEntity((class_1922)level, pos);
        if (crank != null) {
            crank.power();
            return class_1269.method_29236((boolean)level.method_8608());
        }
        return class_1269.field_5811;
    }

    private void dropCrank(class_1937 level, class_2338 pos) {
        level.method_22352(pos, true);
        level.method_8413(pos, this.method_9564(), level.method_8320(pos), 3);
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 blockIn, class_2338 fromPos, boolean isMoving) {
        if (this.getAttachedToPos(state, pos).equals((Object)fromPos) && this.getCrankable(state, level, pos) == null) {
            this.dropCrank(level, pos);
        }
    }

    public boolean method_9558(class_2680 state, class_4538 levelReader, class_2338 pos) {
        if (levelReader instanceof class_1937) {
            class_1937 level = (class_1937)levelReader;
            return this.getCrankable(state, level, pos) != null;
        }
        return true;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        class_2350 top = this.getOrientationStrategy().getSide(state, RelativeSide.FRONT);
        return SHAPES[top.ordinal()];
    }

    @Override
    public IOrientationStrategy getOrientationStrategy() {
        return OrientationStrategies.facing();
    }

    public ICrankable getCrankable(class_2680 state, class_1937 level, class_2338 pos) {
        class_2350 facing = this.getOrientationStrategy().getFacing(state);
        class_2338 attachedToPos = this.getAttachedToPos(state, pos);
        return ICrankable.get(level, attachedToPos, facing);
    }

    private class_2338 getAttachedToPos(class_2680 state, class_2338 pos) {
        class_2350 attachedToSide = this.getOrientationStrategy().getFacing(state).method_10153();
        return pos.method_10093(attachedToSide);
    }

    private static class_265 createShape(class_2350 forward) {
        double xOff = -0.15 * (double)forward.method_10148();
        double yOff = -0.15 * (double)forward.method_10164();
        double zOff = -0.15 * (double)forward.method_10165();
        return class_259.method_31943((double)(xOff + 0.15), (double)(yOff + 0.15), (double)(zOff + 0.15), (double)(xOff + 0.85), (double)(yOff + 0.85), (double)(zOff + 0.85));
    }
}

