/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.misc;

import appeng.api.ids.AETags;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkBlockEntity;
import appeng.core.AEConfig;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class GrowthAcceleratorBlockEntity
extends AENetworkBlockEntity
implements IPowerChannelState {
    public static final int MAX_STORED_POWER = 1600;
    private static final int POWER_PER_TICK = 8;
    private boolean hasPower = false;
    private float storedPower;

    public GrowthAcceleratorBlockEntity(class_2591<?> blockEntityType, class_2338 pos, class_2680 blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]);
        this.getMainNode().setIdlePowerUsage(8.0);
        this.getMainNode().addService(IGridTickable.class, new IGridTickable(){

            @Override
            public TickingRequest getTickingRequest(IGridNode node) {
                int speed = AEConfig.instance().getGrowthAcceleratorSpeed();
                return new TickingRequest(speed, speed, false, false);
            }

            @Override
            public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
                GrowthAcceleratorBlockEntity.this.onTick(ticksSinceLastCall);
                return TickRateModulation.SAME;
            }
        });
    }

    @Override
    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return orientation.getSides(EnumSet.of(RelativeSide.FRONT, RelativeSide.BACK));
    }

    private void onTick(int ticksSinceLastCall) {
        if (this.storedPower > 0.0f) {
            this.storedPower -= (float)(8 * Math.max(1, ticksSinceLastCall));
            if (this.storedPower <= 0.0f) {
                this.storedPower = 0.0f;
                this.markForUpdate();
            }
        } else if (!this.getMainNode().isPowered()) {
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjPos = this.method_11016().method_10093(direction);
            class_2680 adjState = this.method_10997().method_8320(adjPos);
            if (!adjState.method_26164(AETags.GROWTH_ACCELERATABLE)) continue;
            adjState.method_26199((class_3218)this.method_10997(), adjPos, this.method_10997().method_8409());
        }
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (reason == IGridNodeListener.State.POWER) {
            this.markForUpdate();
        }
    }

    @Override
    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    @Override
    public boolean readFromStream(class_2540 data) {
        boolean c = super.readFromStream(data);
        boolean hadPower = this.isPowered();
        this.setPowered(data.readBoolean());
        return this.isPowered() != hadPower || c;
    }

    @Override
    public void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.getMainNode().isPowered());
    }

    @Override
    public boolean isPowered() {
        if (!this.isClientSide()) {
            return this.getMainNode().isPowered() || this.storedPower > 0.0f;
        }
        return this.hasPower;
    }

    @Override
    public boolean isActive() {
        return this.isPowered();
    }

    private void setPowered(boolean hasPower) {
        this.hasPower = hasPower;
    }

    @Nullable
    public ICrankable getCrankable(class_2350 direction) {
        if (direction == this.getFront() || direction == this.getFront().method_10153()) {
            return new Crankable();
        }
        return null;
    }

    class Crankable
    implements ICrankable {
        Crankable() {
        }

        @Override
        public boolean canTurn() {
            return GrowthAcceleratorBlockEntity.this.storedPower < 1600.0f;
        }

        @Override
        public void applyTurn() {
            if (GrowthAcceleratorBlockEntity.this.isClientSide()) {
                return;
            }
            boolean needsUpdate = !GrowthAcceleratorBlockEntity.this.isPowered();
            GrowthAcceleratorBlockEntity.this.storedPower = Math.min(1600.0f, GrowthAcceleratorBlockEntity.this.storedPower + 160.0f);
            if (needsUpdate) {
                GrowthAcceleratorBlockEntity.this.markForUpdate();
            }
        }
    }
}

