/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.Point;
import appeng.client.gui.DashPattern;
import appeng.client.gui.DashedRectangle;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.GuidebookText;
import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.PageCollection;
import appeng.client.guidebook.color.ColorValue;
import appeng.client.guidebook.color.ConstantColor;
import appeng.client.guidebook.color.SymbolicColor;
import appeng.client.guidebook.compiler.AnchorIndexer;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytPoint;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.block.LytDocument;
import appeng.client.guidebook.document.block.LytHeading;
import appeng.client.guidebook.document.block.LytNode;
import appeng.client.guidebook.document.block.LytParagraph;
import appeng.client.guidebook.document.flow.LytFlowAnchor;
import appeng.client.guidebook.document.flow.LytFlowContainer;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowSpan;
import appeng.client.guidebook.document.interaction.GuideTooltip;
import appeng.client.guidebook.document.interaction.InteractiveElement;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.MinecraftFontMetrics;
import appeng.client.guidebook.render.GuidePageTexture;
import appeng.client.guidebook.render.SimpleRenderContext;
import appeng.client.guidebook.screen.GuideIconButton;
import appeng.client.guidebook.screen.GuideNavBar;
import appeng.client.guidebook.screen.GuideScreenHistory;
import appeng.client.guidebook.screen.GuideScrollbar;
import appeng.client.guidebook.style.TextAlignment;
import appeng.client.guidebook.style.TextStyle;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3288;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import net.minecraft.class_8002;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuideScreen
extends class_437 {
    private static final Logger LOG = LoggerFactory.getLogger(GuideScreen.class);
    public static final int DOCUMENT_RECT_MARGIN = 20;
    private static final DashPattern DEBUG_NODE_OUTLINE = new DashPattern(1.0f, 4.0f, 3.0f, -1, 500.0f);
    private static final DashPattern DEBUG_CONTENT_OUTLINE = new DashPattern(0.5f, 2.0f, 1.0f, Integer.MAX_VALUE, 500.0f);
    private static final ColorValue DEBUG_HOVER_OUTLINE_COLOR = new ConstantColor(0x7FFFFF00);
    private static final class_2960 BACKGROUND_TEXTURE = AppEng.makeId("textures/block/sky_stone_block.png");
    private final Guide guide;
    private final GuideScrollbar scrollbar;
    private final GuideScreenHistory history;
    private GuidePage currentPage;
    private final LytParagraph pageTitle;
    private class_4185 backButton;
    private class_4185 forwardButton;
    @Nullable
    private class_437 returnToOnClose;
    @Nullable
    private String pendingScrollToAnchor;

    private GuideScreen(GuideScreenHistory history, Guide guide, PageAnchor anchor) {
        super((class_2561)class_2561.method_43470((String)"AE2 Guidebook"));
        this.history = history;
        this.guide = guide;
        this.scrollbar = new GuideScrollbar();
        this.pageTitle = new LytParagraph();
        this.pageTitle.setStyle(DefaultStyles.HEADING1);
        this.loadPageAndScrollTo(anchor);
    }

    public static GuideScreen openNew(Guide guide, PageAnchor anchor, GuideScreenHistory history) {
        history.push(anchor);
        return new GuideScreen(history, guide, anchor);
    }

    public static GuideScreen openAtPreviousPage(Guide guide, PageAnchor fallbackPage, GuideScreenHistory history) {
        Optional<PageAnchor> historyPage = history.current();
        if (historyPage.isPresent()) {
            return new GuideScreen(history, guide, historyPage.get());
        }
        return GuideScreen.openNew(guide, fallbackPage, history);
    }

    protected void method_25426() {
        super.method_25426();
        this.updatePageLayout();
        this.method_37063((class_364)this.scrollbar);
        this.updateScrollbarPosition();
        GuideNavBar navbar = new GuideNavBar(this);
        this.method_37063((class_364)navbar);
        this.backButton = new GuideIconButton(this.field_22789 - 20 - 48 - 10, 2, GuideIconButton.Role.BACK, this::navigateBack);
        this.method_37063((class_364)this.backButton);
        this.forwardButton = new GuideIconButton(this.field_22789 - 20 - 32 - 5, 2, GuideIconButton.Role.FORWARD, this::navigateForward);
        this.method_37063((class_364)this.forwardButton);
        GuideIconButton closeButton = new GuideIconButton(this.field_22789 - 20 - 16, 2, GuideIconButton.Role.CLOSE, this::method_25419);
        this.method_37063((class_364)closeButton);
        this.updateTopNavButtons();
    }

    private void updateScrollbarPosition() {
        LytRect docRect = this.getDocumentRect();
        this.scrollbar.move(docRect.right(), docRect.y(), docRect.height());
    }

    public void method_25393() {
        this.processPendingScrollTo();
        if (this.currentPage != null) {
            GuideScreen.tickNode(this.currentPage.document());
        }
    }

    private static void tickNode(LytNode node) {
        node.tick();
        for (LytNode lytNode : node.getChildren()) {
            GuideScreen.tickNode(lytNode);
        }
    }

    private void processPendingScrollTo() {
        LytFlowAnchor flowAnchor;
        if (this.pendingScrollToAnchor == null) {
            return;
        }
        String anchor = this.pendingScrollToAnchor;
        this.pendingScrollToAnchor = null;
        AnchorIndexer indexer = new AnchorIndexer(this.currentPage.document());
        AnchorIndexer.AnchorTarget targetAnchor = indexer.get(anchor);
        if (targetAnchor == null) {
            LOG.warn("Failed to find anchor {} in page {}", (Object)anchor, (Object)this.currentPage);
            return;
        }
        LytFlowContent lytFlowContent = targetAnchor.flowContent();
        if (lytFlowContent instanceof LytFlowAnchor && (flowAnchor = (LytFlowAnchor)lytFlowContent).getLayoutY().isPresent()) {
            this.scrollbar.setScrollAmount(flowAnchor.getLayoutY().getAsInt());
        } else {
            LytRect bounds = targetAnchor.blockNode().getBounds();
            this.scrollbar.setScrollAmount(bounds.y());
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateTopNavButtons();
        this.renderSkyStoneBackground(guiGraphics);
        LytRect documentRect = this.getDocumentRect();
        guiGraphics.method_25294(documentRect.x(), documentRect.y(), documentRect.right(), documentRect.bottom(), -2144128205);
        LytRect documentViewport = this.getDocumentViewport();
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416((float)(documentRect.x() - documentViewport.x()), (float)(documentRect.y() - documentViewport.y()), 0.0f);
        LytDocument document = this.currentPage.document();
        SimpleRenderContext context = new SimpleRenderContext(documentViewport, guiGraphics);
        guiGraphics.method_44379(documentRect.x(), documentRect.y(), documentRect.right(), documentRect.bottom());
        class_4597.class_4598 buffers = context.beginBatch();
        document.renderBatch(context, (class_4597)buffers);
        context.endBatch(buffers);
        document.render(context);
        guiGraphics.method_44380();
        if (AEConfig.instance().isShowDebugGuiOverlays()) {
            GuideScreen.renderHoverOutline(document, context);
        }
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 200.0f);
        this.renderTitle(documentRect, context);
        this.renderExternalpageSource(documentRect, context);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        poseStack.method_22909();
        if (document.getHoveredElement() != null) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
    }

    private void renderExternalpageSource(LytRect documentRect, SimpleRenderContext context) {
        String externalSource = this.getExternalSourceName();
        if (externalSource != null) {
            LytParagraph paragraph = new LytParagraph();
            paragraph.appendText(GuidebookText.ContentFrom.text().getString() + " ");
            LytFlowSpan sourceSpan = new LytFlowSpan();
            sourceSpan.appendText(externalSource);
            sourceSpan.setStyle(TextStyle.builder().italic(true).build());
            paragraph.append(sourceSpan);
            paragraph.setStyle(TextStyle.builder().alignment(TextAlignment.RIGHT).build());
            LayoutContext layoutContext = new LayoutContext(new MinecraftFontMetrics());
            paragraph.layout(layoutContext, documentRect.x(), documentRect.bottom(), documentRect.width());
            class_4597.class_4598 buffers = context.beginBatch();
            paragraph.renderBatch(context, (class_4597)buffers);
            context.endBatch(buffers);
        }
    }

    @Nullable
    private String getExternalSourceName() {
        String sourcePackId = this.currentPage.sourcePack();
        if (sourcePackId.startsWith("mod:")) {
            String modId = sourcePackId.substring("mod:".length());
            if (this.guide.getDefaultNamespace().equals(modId)) {
                return null;
            }
            return FabricLoaderImpl.INSTANCE.getModContainer(modId).map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(null);
        }
        if (this.guide.getDefaultNamespace().equals(sourcePackId)) {
            return null;
        }
        class_3288 pack = class_310.method_1551().method_1520().method_14449(sourcePackId);
        if (pack != null) {
            return pack.method_14459().getString();
        }
        return null;
    }

    public void method_25420(class_332 graphics) {
    }

    private void renderTitle(LytRect documentRect, SimpleRenderContext context) {
        class_4597.class_4598 buffers = context.beginBatch();
        this.pageTitle.renderBatch(context, (class_4597)buffers);
        context.endBatch(buffers);
        context.fillRect(documentRect.x(), documentRect.y() - 1, documentRect.width(), 1, (ColorValue)SymbolicColor.HEADER1_SEPARATOR);
    }

    private void renderSkyStoneBackground(class_332 guiGraphics) {
        RenderSystem.setShaderColor((float)0.25f, (float)0.25f, (float)0.25f, (float)1.0f);
        guiGraphics.method_25291(BACKGROUND_TEXTURE, 0, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, 32, 32);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderTooltip(class_332 guiGraphics, int x, int y) {
        Point docPos = this.getDocumentPoint(x, y);
        if (docPos == null) {
            return;
        }
        LytDocument.HitTestResult hoveredElement = this.currentPage.document().getHoveredElement();
        if (hoveredElement != null) {
            GuideScreen.dispatchInteraction(hoveredElement, el -> el.getTooltip(docPos.getX(), docPos.getY())).ifPresent(tooltip -> this.renderTooltip(guiGraphics, (GuideTooltip)tooltip, x, y));
        }
    }

    private static void renderHoverOutline(LytDocument document, SimpleRenderContext context) {
        LytDocument.HitTestResult hoveredElement = document.getHoveredElement();
        if (hoveredElement != null) {
            LytNode lytNode = hoveredElement.node();
            if (lytNode instanceof LytBlock) {
                LytBlock block = (LytBlock)lytNode;
                LytRect bounds = block.getBounds();
                if (block.getMarginTop() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginTop()).move(0, -block.getMarginTop()), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginBottom() > 0) {
                    context.fillRect(bounds.withHeight(block.getMarginBottom()).move(0, bounds.height()), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginLeft() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginLeft()).move(-block.getMarginLeft(), 0), DEBUG_HOVER_OUTLINE_COLOR);
                }
                if (block.getMarginRight() > 0) {
                    context.fillRect(bounds.withWidth(block.getMarginRight()).move(bounds.width(), 0), DEBUG_HOVER_OUTLINE_COLOR);
                }
            }
            DashedRectangle.render(context.poseStack(), hoveredElement.node().getBounds(), DEBUG_NODE_OUTLINE, 0.0f);
            if (hoveredElement.content() != null && (lytNode = hoveredElement.node()) instanceof LytFlowContainer) {
                LytFlowContainer flowContainer = (LytFlowContainer)((Object)lytNode);
                flowContainer.enumerateContentBounds(hoveredElement.content()).forEach(bound -> DashedRectangle.render(context.poseStack(), bound, DEBUG_CONTENT_OUTLINE, 0.0f));
            }
            LytRect bounds = hoveredElement.node().getBounds();
            context.renderText(hoveredElement.node().getClass().getName(), DefaultStyles.BASE_STYLE, bounds.x(), bounds.bottom());
        }
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseMoved(this, docPoint.getX(), docPoint.getY()));
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            if (button == 3) {
                this.navigateBack();
            } else if (button == 4) {
                this.navigateForward();
            }
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseClicked(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (super.method_25406(mouseX, mouseY, button)) {
            return true;
        }
        Point docPoint = this.getDocumentPoint(mouseX, mouseY);
        if (docPoint != null) {
            return this.dispatchEvent(docPoint.getX(), docPoint.getY(), el -> el.mouseReleased(this, docPoint.getX(), docPoint.getY(), button));
        }
        return false;
    }

    public void navigateTo(class_2960 pageId) {
        this.navigateTo(new PageAnchor(pageId, null));
    }

    public void navigateTo(PageAnchor anchor) {
        if (this.currentPage.id().equals((Object)anchor.pageId())) {
            this.pendingScrollToAnchor = anchor.anchor();
            if (anchor.anchor() != null) {
                this.history.push(anchor);
            }
            return;
        }
        this.loadPageAndScrollTo(anchor);
        this.history.push(anchor);
    }

    private void navigateForward() {
        this.history.forward().ifPresent(this::loadPageAndScrollTo);
    }

    private void navigateBack() {
        this.history.back().ifPresent(this::loadPageAndScrollTo);
    }

    private void loadPageAndScrollTo(PageAnchor anchor) {
        this.loadPage(anchor.pageId());
        this.scrollbar.setScrollAmount(0);
        this.updatePageLayout();
        this.pendingScrollToAnchor = anchor.anchor();
    }

    public void reloadPage() {
        this.loadPage(this.currentPage.id());
        this.updatePageLayout();
    }

    private void loadPage(class_2960 pageId) {
        GuidePageTexture.releaseUsedTextures();
        ParsedGuidePage page = this.guide.getParsedPage(pageId);
        if (page == null) {
            page = this.buildNotFoundPage(pageId);
        }
        this.currentPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
        this.pageTitle.clearContent();
        for (LytFlowContent flowContent : this.extractPageTitle(this.currentPage)) {
            this.pageTitle.append(flowContent);
        }
    }

    private Iterable<LytFlowContent> extractPageTitle(GuidePage page) {
        for (LytBlock block : page.document().getBlocks()) {
            if (!(block instanceof LytHeading)) continue;
            LytHeading heading = (LytHeading)block;
            if (heading.getDepth() != 1) break;
            page.document().removeChild(heading);
            return heading.getContent();
        }
        return List.of();
    }

    private ParsedGuidePage buildNotFoundPage(class_2960 pageId) {
        String pageSource = "# Page not Found\n\nPage \"" + pageId + "\" could not be found.";
        return PageCompiler.parse(pageId.method_12836(), pageId, pageSource);
    }

    public void method_25432() {
        super.method_25432();
        GuidePageTexture.releaseUsedTextures();
    }

    public void setReturnToOnClose(@Nullable class_437 screen) {
        this.returnToOnClose = screen;
    }

    public void openUrl(String href) {
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (IllegalArgumentException ignored) {
            LOG.debug("Can't parse '{}' as URL in '{}'", (Object)href, (Object)this.currentPage);
            return;
        }
        if (uri.getScheme() != null) {
            if (((Boolean)this.field_22787.field_1690.method_42431().method_41753()).booleanValue()) {
                this.field_22787.method_1507((class_437)new class_407(doOpen -> {
                    if (doOpen) {
                        class_156.method_668().method_673(uri);
                    }
                    this.field_22787.method_1507((class_437)this);
                }, href, false));
            } else {
                class_156.method_668().method_673(uri);
            }
        } else {
            class_2960 pageId = AppEng.makeId(uri.getSchemeSpecificPart());
            PageAnchor anchor = new PageAnchor(pageId, uri.getFragment());
            this.history.push(anchor);
            this.loadPageAndScrollTo(anchor);
        }
    }

    private boolean dispatchEvent(int x, int y, EventInvoker invoker) {
        return this.dispatchInteraction(x, y, el -> {
            if (invoker.invoke((InteractiveElement)el)) {
                return Optional.of(true);
            }
            return Optional.empty();
        }).orElse(false);
    }

    private <T> Optional<T> dispatchInteraction(int x, int y, Function<InteractiveElement, Optional<T>> invoker) {
        LytDocument.HitTestResult underCursor = this.currentPage.document().pick(x, y);
        if (underCursor != null) {
            return GuideScreen.dispatchInteraction(underCursor, invoker);
        }
        return Optional.empty();
    }

    private static <T> Optional<T> dispatchInteraction(LytDocument.HitTestResult receiver, Function<InteractiveElement, Optional<T>> invoker) {
        InteractiveElement interactiveEl;
        Optional<T> result;
        for (LytFlowContent el = receiver.content(); el != null; el = el.getFlowParent()) {
            if (!(el instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)el))).isPresent()) continue;
            return result;
        }
        for (LytNode node = receiver.node(); node != null; node = node.getParent()) {
            if (!(node instanceof InteractiveElement) || !(result = invoker.apply(interactiveEl = (InteractiveElement)((Object)node))).isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    public void method_37068() {
        super.method_37068();
        class_312 mouseHandler = this.field_22787.field_1729;
        double scale = (double)this.field_22787.method_22683().method_4486() / (double)this.field_22787.method_22683().method_4480();
        double x = mouseHandler.method_1603() * scale;
        double y = mouseHandler.method_1604() * scale;
        LytDocument document = this.currentPage.document();
        if (this.method_19355(x, y).isPresent()) {
            document.setHoveredElement(null);
            return;
        }
        Point docPoint = this.getDocumentPoint(x, y);
        if (docPoint != null) {
            LytDocument.HitTestResult hoveredEl = document.pick(docPoint.getX(), docPoint.getY());
            document.setHoveredElement(hoveredEl);
        } else {
            document.setHoveredElement(null);
        }
    }

    @Nullable
    public Point getDocumentPoint(double screenX, double screenY) {
        LytRect documentRect = this.getDocumentRect();
        if (screenX >= (double)documentRect.x() && screenX < (double)documentRect.right() && screenY >= (double)documentRect.y() && screenY < (double)documentRect.bottom()) {
            int docX = (int)Math.round(screenX - (double)documentRect.x());
            int docY = (int)Math.round(screenY + (double)this.scrollbar.getScrollAmount() - (double)documentRect.y());
            return new Point(docX, docY);
        }
        return null;
    }

    public LytPoint getScreenPoint(LytPoint documentPoint) {
        LytRect documentRect = this.getDocumentRect();
        LytRect documentViewport = this.getDocumentViewport();
        float x = documentPoint.x() - (float)documentViewport.x();
        float y = documentPoint.y() - (float)documentViewport.y();
        return new LytPoint((float)documentRect.x() + x, (float)documentRect.y() + y);
    }

    private LytRect getDocumentRect() {
        int margin = 20;
        int marginTop = Math.max(margin, 5 + this.pageTitle.getBounds().height());
        return new LytRect(margin, marginTop, this.field_22789 - 2 * margin, this.field_22790 - margin - marginTop);
    }

    private LytRect getDocumentViewport() {
        LytRect documentRect = this.getDocumentRect();
        return new LytRect(0, this.scrollbar.getScrollAmount(), documentRect.width(), documentRect.height());
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (!super.method_25401(mouseX, mouseY, delta)) {
            return this.scrollbar.method_25401(mouseX, mouseY, delta);
        }
        return true;
    }

    private void renderTooltip(class_332 guiGraphics, GuideTooltip tooltip, int mouseX, int mouseY) {
        class_5684 line;
        int i;
        class_310 minecraft = class_310.method_1551();
        List<class_5684> clientLines = tooltip.getLines();
        if (clientLines.isEmpty()) {
            return;
        }
        int frameWidth = 0;
        int frameHeight = clientLines.size() == 1 ? -2 : 0;
        for (class_5684 clientTooltipComponent : clientLines) {
            frameWidth = Math.max(frameWidth, clientTooltipComponent.method_32664(minecraft.field_1772));
            frameHeight += clientTooltipComponent.method_32661();
        }
        if (!tooltip.getIcon().method_7960()) {
            frameWidth += 18;
            frameHeight = Math.max(frameHeight, 18);
        }
        int x = mouseX + 12;
        int y = mouseY - 12;
        if (x + frameWidth > this.field_22789) {
            x -= 28 + frameWidth;
        }
        if (y + frameHeight + 6 > this.field_22790) {
            y = this.field_22790 - frameHeight - 6;
        }
        int zOffset = 400;
        class_8002.method_47946((class_332)guiGraphics, (int)x, (int)y, (int)frameWidth, (int)frameHeight, (int)zOffset);
        if (!tooltip.getIcon().method_7960()) {
            x += 18;
        }
        class_4587 poseStack = guiGraphics.method_51448();
        class_4597.class_4598 bufferSource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        poseStack.method_22903();
        poseStack.method_22904(0.0, 0.0, (double)zOffset);
        int currentY = y;
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.method_32665(minecraft.field_1772, x, currentY, poseStack.method_23760().method_23761(), bufferSource);
            currentY += line.method_32661() + (i == 0 ? 2 : 0);
        }
        bufferSource.method_22993();
        currentY = y;
        if (!tooltip.getIcon().method_7960()) {
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, (float)zOffset);
            guiGraphics.method_51427(tooltip.getIcon(), x - 18, y);
            poseStack.method_22909();
        }
        for (i = 0; i < clientLines.size(); ++i) {
            line = clientLines.get(i);
            line.method_32666(minecraft.field_1772, x, currentY, guiGraphics);
            currentY += line.method_32661() + (i == 0 ? 2 : 0);
        }
        poseStack.method_22909();
    }

    private void updatePageLayout() {
        this.updateTitleLayout();
        LytRect docViewport = this.getDocumentViewport();
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        LytDocument document = this.currentPage.document();
        document.updateLayout(context, docViewport.width());
        this.scrollbar.setContentHeight(document.getContentHeight());
    }

    private void updateTitleLayout() {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        int availableWidth = this.field_22789;
        availableWidth -= 40;
        availableWidth -= 37;
        if ((availableWidth -= 10) < 0) {
            availableWidth = 0;
        }
        this.pageTitle.layout(context, 0, 0, availableWidth);
        int height = this.pageTitle.getBounds().height();
        LytRect documentRect = this.getDocumentRect();
        int titleY = (documentRect.y() - height) / 2;
        this.pageTitle.layout(context, documentRect.x() + 5, titleY, availableWidth);
        this.updateScrollbarPosition();
    }

    public class_2960 getCurrentPageId() {
        return this.currentPage.id();
    }

    private void updateTopNavButtons() {
        this.backButton.field_22763 = this.history.peekBack().isPresent();
        this.forwardButton.field_22763 = this.history.peekForward().isPresent();
    }

    public PageCollection getGuide() {
        return this.guide;
    }

    public void method_25419() {
        if (this.field_22787 != null && this.field_22787.field_1755 == this && this.returnToOnClose != null) {
            this.field_22787.method_1507(this.returnToOnClose);
            this.returnToOnClose = null;
            return;
        }
        super.method_25419();
    }

    @FunctionalInterface
    static interface EventInvoker {
        public boolean invoke(InteractiveElement var1);
    }
}

