/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKeyType;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ExtractionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.InsertionOnlyStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2350;

public abstract class StorageP2PTunnelPart<P extends StorageP2PTunnelPart<P, T>, T extends TransferVariant<?>>
extends CapabilityP2PTunnelPart<P, Storage<T>> {
    private AEKeyType keyType;

    public StorageP2PTunnelPart(IPartItem<?> partItem, BlockApiLookup<Storage<T>, class_2350> api, AEKeyType keyType) {
        super(partItem, api);
        this.inputHandler = new InputStorage();
        this.outputHandler = new OutputStorage();
        this.emptyHandler = Storage.empty();
        this.keyType = keyType;
    }

    private class InputStorage
    implements InsertionOnlyStorage<T> {
        private InputStorage() {
        }

        public long insert(T resource, long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notBlankNotNegative(resource, (long)maxAmount);
            long total = 0L;
            List outputs = StorageP2PTunnelPart.this.getOutputs();
            int outputTunnels = outputs.size();
            long amount = maxAmount;
            if (outputTunnels == 0 || amount == 0L) {
                return 0L;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (StorageP2PTunnelPart target : outputs) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    Storage output = (Storage)capabilityGuard.get();
                    long toSend = amountPerOutput + overflow;
                    long received = output.insert(resource, toSend, transaction);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            double energyDrain = (double)total / (double)StorageP2PTunnelPart.this.keyType.getAmountPerOperation();
            StorageP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, energyDrain, transaction);
            return total;
        }

        public Iterator<StorageView<T>> iterator() {
            return Collections.emptyIterator();
        }
    }

    private class OutputStorage
    implements ExtractionOnlyStorage<T> {
        private OutputStorage() {
        }

        public long extract(T resource, long maxAmount, TransactionContext transaction) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = StorageP2PTunnelPart.this.getInputCapability();){
                long extracted = ((Storage)input.get()).extract(resource, maxAmount, transaction);
                double energyDrain = (double)extracted / (double)StorageP2PTunnelPart.this.keyType.getAmountPerOperation();
                StorageP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, energyDrain, transaction);
                long l = extracted;
                return l;
            }
        }

        public Iterator<StorageView<T>> iterator() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = StorageP2PTunnelPart.this.getInputCapability();){
                Iterator iterator = Iterators.transform((Iterator)((Storage)input.get()).iterator(), x$0 -> new PowerDrainingStorageView(x$0));
                return iterator;
            }
        }
    }

    private class PowerDrainingStorageView
    implements StorageView<T> {
        private final StorageView<T> delegate;

        public PowerDrainingStorageView(StorageView<T> delegate) {
            this.delegate = delegate;
        }

        public long extract(T resource, long maxAmount, TransactionContext transaction) {
            long extracted = this.delegate.extract(resource, maxAmount, transaction);
            double energyDrain = (double)extracted / (double)StorageP2PTunnelPart.this.keyType.getAmountPerOperation();
            StorageP2PTunnelPart.this.queueTunnelDrain(PowerUnits.AE, energyDrain, transaction);
            return extracted;
        }

        public boolean isResourceBlank() {
            return this.delegate.isResourceBlank();
        }

        public T getResource() {
            return (TransferVariant)this.delegate.getResource();
        }

        public long getAmount() {
            return this.delegate.getAmount();
        }

        public long getCapacity() {
            return this.delegate.getCapacity();
        }
    }
}

