/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.recipes.entropy.PropertyUtils;
import appeng.recipes.entropy.StateMatcher;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2540;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

class RangeValueMatcher<T extends Comparable<T>>
implements StateMatcher {
    private final class_2769<T> property;
    private final T minValue;
    private final T maxValue;

    private RangeValueMatcher(class_2769<T> property, String minValueName, String maxValueName) {
        this.property = Objects.requireNonNull(property, "property must not be null");
        this.minValue = PropertyUtils.getRequiredPropertyValue(property, minValueName);
        this.maxValue = PropertyUtils.getRequiredPropertyValue(property, maxValueName);
    }

    @Override
    public boolean matches(class_2688<?, ?> state) {
        Comparable value = state.method_11654(this.property);
        return value.compareTo(this.minValue) >= 0 && value.compareTo(this.maxValue) <= 0;
    }

    @Override
    public void writeToPacket(class_2540 buffer) {
        buffer.method_10817((Enum)StateMatcher.MatcherType.RANGE);
        buffer.method_10814(this.property.method_11899());
        buffer.method_10814(this.property.method_11901(this.minValue));
        buffer.method_10814(this.property.method_11901(this.maxValue));
    }

    @Override
    public class_2769<?> getProperty() {
        return this.property;
    }

    public String getMinValueName() {
        return this.property.method_11901(this.minValue);
    }

    public String getMaxValueName() {
        return this.property.method_11901(this.maxValue);
    }

    public static StateMatcher create(class_2689<?, ?> stateDefinition, String propertyName, String minValueName, String maxValueName) {
        class_2769<?> property = PropertyUtils.getRequiredProperty(stateDefinition, propertyName);
        return new RangeValueMatcher(property, minValueName, maxValueName);
    }

    @Environment(value=EnvType.CLIENT)
    public static StateMatcher readFromPacket(class_2689<?, ?> stateDefinition, class_2540 buffer) {
        String propertyName = buffer.method_19772();
        String minName = buffer.method_19772();
        String maxName = buffer.method_19772();
        return RangeValueMatcher.create(stateDefinition, propertyName, minName, maxName);
    }
}

