/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.testworld;

import appeng.server.testworld.BuildAction;
import appeng.server.testworld.PlotBuilder;
import appeng.server.testworld.PlotTestHelper;
import appeng.server.testworld.Test;
import appeng.server.testworld.TransformingPlotBuilder;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3341;

public class Plot
implements PlotBuilder {
    private final class_2960 id;
    private final List<BuildAction> buildActions = new ArrayList<BuildAction>();
    private Test test;
    private static final Pattern RANGE = Pattern.compile("\\[(-?\\d+),(-?\\d+)]");

    public class_3341 getBounds() {
        return (class_3341)class_3341.method_35413(this.buildActions.stream().map(BuildAction::getBoundingBox).toList()).orElseThrow();
    }

    public Plot(class_2960 id) {
        this.id = id;
    }

    public class_2960 getId() {
        return this.id;
    }

    @Override
    public void addBuildAction(BuildAction action) {
        this.buildActions.add(action);
    }

    @Override
    public PlotBuilder transform(Function<class_3341, class_3341> transform) {
        return new TransformingPlotBuilder(this, transform);
    }

    @Override
    public class_3341 bb(String def) {
        int[] p;
        String[] parts = def.split("\\s+");
        Preconditions.checkArgument((parts.length * 2 == (p = new int[6]).length ? 1 : 0) != 0);
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            Matcher rangeMatch = RANGE.matcher(part);
            if (rangeMatch.matches()) {
                p[i * 2] = Integer.parseInt(rangeMatch.group(1));
                p[i * 2 + 1] = Integer.parseInt(rangeMatch.group(2));
                continue;
            }
            int n = Integer.parseInt(part);
            p[i * 2 + 1] = n;
            p[i * 2] = n;
        }
        Preconditions.checkArgument((p[0] <= p[1] ? 1 : 0) != 0, (String)"Invalid bb: %s", (Object)def);
        Preconditions.checkArgument((p[2] <= p[3] ? 1 : 0) != 0, (String)"Invalid bb: %s", (Object)def);
        Preconditions.checkArgument((p[4] <= p[5] ? 1 : 0) != 0, (String)"Invalid bb: %s", (Object)def);
        return new class_3341(p[0], p[2], p[4], p[1], p[3], p[5]);
    }

    public void build(class_3218 level, class_1657 player, class_2338 origin) {
        this.build(level, player, origin, new ArrayList<class_1297>());
    }

    public void build(class_3218 level, class_1657 player, class_2338 origin, List<class_1297> entities) {
        for (BuildAction action : this.buildActions) {
            action.build(level, player, origin);
        }
        for (BuildAction action : this.buildActions) {
            action.spawnEntities(level, origin, entities);
        }
    }

    public Test getTest() {
        return this.test;
    }

    @Override
    public Test test(Consumer<PlotTestHelper> testFunction) {
        this.test = new Test(testFunction);
        return this.test;
    }
}

