/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.bom;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.FoldState;
import dev.emi.emi.bom.MaterialTree;
import dev.emi.emi.bom.ProgressState;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MaterialNode {
    public final EmiIngredient ingredient;
    public final EmiStack remainder;
    @Nullable
    public EmiRecipe recipe;
    @Nullable
    public List<MaterialNode> children;
    public float consumeChance;
    public float produceChance;
    public long amount;
    public long divisor;
    public long remainderAmount;
    public boolean catalyst;
    public FoldState state;
    public ProgressState progress;
    public long neededBatches;
    public long totalNeeded;

    public MaterialNode(EmiIngredient ingredient) {
        block3: {
            this.consumeChance = 1.0f;
            this.produceChance = 1.0f;
            this.amount = 1L;
            this.divisor = 1L;
            this.remainderAmount = 0L;
            this.catalyst = false;
            this.state = FoldState.EXPANDED;
            this.progress = ProgressState.UNSTARTED;
            this.neededBatches = 0L;
            this.totalNeeded = 0L;
            this.amount = ingredient.getAmount();
            this.ingredient = ingredient.copy().setAmount(1L).setChance(1.0f);
            if (this.ingredient.getEmiStacks().size() == 1) {
                this.remainder = this.ingredient.getEmiStacks().get(0).getRemainder();
                this.remainderAmount = this.remainder.getAmount();
                this.remainder.setAmount(1L);
            } else {
                this.remainder = EmiStack.EMPTY;
            }
            for (EmiStack stack : ingredient.getEmiStacks()) {
                if (stack.getRemainder().equals(stack)) continue;
                break block3;
            }
            this.catalyst = true;
        }
    }

    public MaterialNode(MaterialNode node) {
        this.consumeChance = 1.0f;
        this.produceChance = 1.0f;
        this.amount = 1L;
        this.divisor = 1L;
        this.remainderAmount = 0L;
        this.catalyst = false;
        this.state = FoldState.EXPANDED;
        this.progress = ProgressState.UNSTARTED;
        this.neededBatches = 0L;
        this.totalNeeded = 0L;
        this.ingredient = node.ingredient;
        this.remainder = node.remainder;
        this.recipe = node.recipe;
        this.amount = node.amount;
        this.divisor = node.divisor;
        this.remainderAmount = node.remainderAmount;
    }

    public void recalculate(MaterialTree tree) {
        this.recalculate(tree, Lists.newArrayList());
    }

    private void recalculate(MaterialTree tree, List<EmiRecipe> used) {
        EmiRecipe recipe = this.recipe;
        if (!used.isEmpty()) {
            recipe = tree.getRecipe(this.ingredient);
        }
        if (recipe != null) {
            if (used.contains(recipe)) {
                return;
            }
            used.add(recipe);
            this.defineRecipe(recipe);
            for (MaterialNode node : this.children) {
                node.recalculate(tree, used);
            }
            used.remove(used.size() - 1);
        }
    }

    public void defineRecipe(EmiRecipe recipe) {
        this.produceChance = 1.0f;
        if (recipe == null) {
            return;
        }
        this.recipe = recipe;
        this.divisor = 0L;
        for (EmiStack stack : recipe.getOutputs()) {
            if (!stack.equals(this.ingredient)) continue;
            if (this.divisor > 0L) {
                if (this.produceChance != 1.0f || stack.getChance() != 1.0f) {
                    this.produceChance = ((float)stack.getAmount() * stack.getChance() + (float)this.divisor * this.produceChance) / (float)(this.divisor + stack.getAmount());
                }
                this.divisor += stack.getAmount();
                continue;
            }
            this.divisor = stack.getAmount();
            this.produceChance = stack.getChance();
        }
        if (this.divisor <= 0L) {
            this.divisor = 1L;
        }
        this.children = Lists.newArrayList();
        block1: for (EmiIngredient i : recipe.getInputs()) {
            EmiStack remainder = EmiStack.EMPTY;
            if (i.getEmiStacks().size() == 1) {
                remainder = i.getEmiStacks().get(0).getRemainder();
            }
            for (MaterialNode node : this.children) {
                if (!EmiIngredient.areEqual(i, node.ingredient) || !EmiIngredient.areEqual(remainder, node.remainder)) continue;
                node.amount += i.getAmount();
                node.remainderAmount += remainder.getAmount();
                continue block1;
            }
            if (i.isEmpty()) continue;
            MaterialNode node = new MaterialNode(i);
            node.consumeChance = i.getChance();
            this.children.add(node);
        }
    }
}

