/*
 * Decompiled with CFR 0.152.
 */
package net.xanthian.variantchests.renderer;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2350;
import net.minecraft.class_2618;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_4732;
import net.minecraft.class_4737;
import net.minecraft.class_5602;
import net.minecraft.class_5614;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_826;
import net.xanthian.variantchests.block.VariantChestBlock;
import net.xanthian.variantchests.block.VariantChests;
import net.xanthian.variantchests.entity.VariantChestBlockEntity;

@Environment(value=EnvType.CLIENT)
public class VariantChestRenderer
extends class_826<VariantChestBlockEntity> {
    public static class_4730[] single = new class_4730[VariantChests.values().length];
    public static class_4730[] left = new class_4730[VariantChests.values().length];
    public static class_4730[] right = new class_4730[VariantChests.values().length];
    private final class_630 singleChestLid;
    private final class_630 singleChestBase;
    private final class_630 singleChestLock;
    private final class_630 doubleChestLeftBase;
    private final class_630 doubleChestLeftLid;
    private final class_630 doubleChestLeftLock;
    private final class_630 doubleChestRightBase;
    private final class_630 doubleChestRightLid;
    private final class_630 doubleChestRightLock;

    public VariantChestRenderer(class_5614.class_5615 context) {
        super(context);
        class_630 modelPart = context.method_32140(class_5602.field_27689);
        this.singleChestBase = modelPart.method_32086("bottom");
        this.singleChestLid = modelPart.method_32086("lid");
        this.singleChestLock = modelPart.method_32086("lock");
        class_630 modelPart2 = context.method_32140(class_5602.field_27551);
        this.doubleChestLeftBase = modelPart2.method_32086("bottom");
        this.doubleChestLeftLid = modelPart2.method_32086("lid");
        this.doubleChestLeftLock = modelPart2.method_32086("lock");
        class_630 modelPart3 = context.method_32140(class_5602.field_27552);
        this.doubleChestRightBase = modelPart3.method_32086("bottom");
        this.doubleChestRightLid = modelPart3.method_32086("lid");
        this.doubleChestRightLock = modelPart3.method_32086("lock");
    }

    public static class_4730 getChestID(String path) {
        return new class_4730(class_4722.field_21709, new class_2960("variantchests", "entity/chest/" + path));
    }

    public static class_4730 chooseMaterial(class_2745 type, class_4730 left, class_4730 right, class_4730 single) {
        return switch (type) {
            case class_2745.field_12574 -> left;
            case class_2745.field_12571 -> right;
            default -> single;
        };
    }

    private class_4730 getChestTexture(VariantChestBlockEntity tile, class_2745 type) {
        return VariantChestRenderer.chooseMaterial(type, left[tile.getChestType().ordinal()], right[tile.getChestType().ordinal()], single[tile.getChestType().ordinal()]);
    }

    public void render(VariantChestBlockEntity entity, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 world = entity.method_10997();
        class_2680 blockState = world != null ? entity.method_11010() : (class_2680)class_2246.field_10034.method_9564().method_11657((class_2769)class_2281.field_10768, (Comparable)class_2350.field_11035);
        class_2745 chestType = blockState.method_28498((class_2769)class_2281.field_10770) ? (class_2745)blockState.method_11654((class_2769)class_2281.field_10770) : class_2745.field_12569;
        class_2248 block = blockState.method_26204();
        if (block instanceof VariantChestBlock) {
            boolean bl2 = chestType != class_2745.field_12569;
            matrices.method_22903();
            float f = ((class_2350)blockState.method_11654((class_2769)class_2281.field_10768)).method_10144();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotationDegrees(-f));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            class_4732.class_4734 propertySource = world == null ? class_4732.class_3923::method_24174 : ((VariantChestBlock)block).method_24167(blockState, world, entity.method_11016(), true);
            float g = ((Float2FloatFunction)propertySource.apply(class_2281.method_24166((class_2618)entity))).get(tickDelta);
            g = 1.0f - g;
            g = 1.0f - g * g * g;
            int i = ((Int2IntFunction)propertySource.apply((class_4732.class_3923)new class_4737())).applyAsInt(light);
            class_4730 spriteIdentifier = this.getChestTexture(entity, chestType);
            class_4588 vertexConsumer = spriteIdentifier.method_24145(vertexConsumers, class_1921::method_23576);
            if (bl2) {
                if (chestType == class_2745.field_12574) {
                    this.render(matrices, vertexConsumer, this.doubleChestLeftLid, this.doubleChestLeftLock, this.doubleChestLeftBase, g, i, overlay);
                } else {
                    this.render(matrices, vertexConsumer, this.doubleChestRightLid, this.doubleChestRightLock, this.doubleChestRightBase, g, i, overlay);
                }
            } else {
                this.render(matrices, vertexConsumer, this.singleChestLid, this.singleChestLock, this.singleChestBase, g, i, overlay);
            }
            matrices.method_22909();
        }
    }

    private void render(class_4587 matrices, class_4588 vertices, class_630 lid, class_630 latch, class_630 base, float openFactor, int light, int overlay) {
        latch.field_3654 = lid.field_3654 = -(openFactor * 1.5707964f);
        lid.method_22698(matrices, vertices, light, overlay);
        latch.method_22698(matrices, vertices, light, overlay);
        base.method_22698(matrices, vertices, light, overlay);
    }

    static {
        for (VariantChests type : VariantChests.values()) {
            int ordinal = type.ordinal();
            String name = type.name().toLowerCase(Locale.ROOT);
            VariantChestRenderer.single[ordinal] = VariantChestRenderer.getChestID(name + "_chest");
            VariantChestRenderer.left[ordinal] = VariantChestRenderer.getChestID(name + "_chest_left");
            VariantChestRenderer.right[ordinal] = VariantChestRenderer.getChestID(name + "_chest_right");
        }
    }
}

