/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import com.ordana.spelunkery.reg.ModItems;
import com.ordana.spelunkery.utils.TranslationUtils;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3675;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HandheldCompactorItem
extends class_1792 {
    public static final Supplier<BiMap<class_1792, class_1792>> NUGGET_COMPACTING = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_1802.field_8675, (Object)class_1802.field_8620).put((Object)class_1802.field_8397, (Object)class_1802.field_8695).put((Object)ModItems.COPPER_NUGGET.get(), (Object)class_1802.field_27022).put((Object)ModItems.RAW_IRON_NUGGET.get(), (Object)class_1802.field_33400).put((Object)ModItems.RAW_GOLD_NUGGET.get(), (Object)class_1802.field_33402).put((Object)ModItems.RAW_COPPER_NUGGET.get(), (Object)class_1802.field_33401).put((Object)ModItems.RAW_MAGNETITE_NUGGET.get(), (Object)ModItems.RAW_MAGNETITE.get()).put((Object)ModItems.CINNABAR_SHARD.get(), (Object)ModItems.CINNABAR.get()).put((Object)ModItems.LAPIS_LAZULI_SHARD.get(), (Object)class_1802.field_8759).put((Object)ModItems.EMERALD_SHARD.get(), (Object)class_1802.field_8687).put((Object)ModItems.DIAMOND_SHARD.get(), (Object)class_1802.field_8477).put((Object)ModItems.ROUGH_CINNABAR_SHARD.get(), (Object)ModItems.ROUGH_CINNABAR.get()).put((Object)ModItems.ROUGH_LAZURITE_SHARD.get(), (Object)ModItems.ROUGH_LAZURITE.get()).put((Object)ModItems.ROUGH_EMERALD_SHARD.get(), (Object)ModItems.ROUGH_EMERALD.get()).put((Object)ModItems.ROUGH_DIAMOND_SHARD.get(), (Object)ModItems.ROUGH_DIAMOND.get());
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "spelunkery:rough_jade_shard", "sullysmod:rough_jade");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "spelunkery:raw_silver_nugget", "oreganized:raw_silver");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "spelunkery:raw_lead_nugget", "oreganized:raw_lead");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "spelunkery:raw_zinc_nugget", "create:raw_zinc");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "spelunkery:jade_shard", "sullysmod:jade");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:silver_nugget", "oreganized:silver_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:lead_nugget", "oreganized:lead_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "create:zinc_nugget", "create:zinc_ingot");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "create:brass_nugget", "create:brass_ingot");
        return builder.build();
    });
    public static final Supplier<BiMap<class_1792, class_1792>> INGOT_COMPACTING = Suppliers.memoize(() -> {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder().put((Object)class_1802.field_8620, (Object)class_1802.field_8773).put((Object)class_1802.field_8695, (Object)class_1802.field_8494).put((Object)class_1802.field_27022, (Object)class_1802.field_27071).put((Object)class_1802.field_33400, (Object)class_1802.field_33505).put((Object)class_1802.field_33402, (Object)class_1802.field_33507).put((Object)class_1802.field_33401, (Object)class_1802.field_33506).put((Object)ModItems.RAW_MAGNETITE.get(), (Object)ModBlocks.RAW_MAGNETITE_BLOCK.get().method_8389()).put((Object)ModItems.CINNABAR.get(), (Object)ModBlocks.CINNABAR_BLOCK.get().method_8389()).put((Object)class_1802.field_8725, (Object)class_1802.field_8793).put((Object)class_1802.field_8759, (Object)class_1802.field_8055).put((Object)class_1802.field_8687, (Object)class_1802.field_8733).put((Object)class_1802.field_8477, (Object)class_1802.field_8603).put((Object)ModItems.ROUGH_CINNABAR.get(), (Object)ModBlocks.ROUGH_CINNABAR_BLOCK.get().method_8389()).put((Object)ModItems.ROUGH_LAZURITE.get(), (Object)ModBlocks.ROUGH_LAZURITE_BLOCK.get().method_8389()).put((Object)ModItems.ROUGH_EMERALD.get(), (Object)ModBlocks.ROUGH_EMERALD_BLOCK.get().method_8389()).put((Object)ModItems.ROUGH_DIAMOND.get(), (Object)ModBlocks.ROUGH_DIAMOND_BLOCK.get().method_8389());
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "sullysmod:rough_jade", "sullysmod:rough_jade_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:raw_silver", "oreganized:raw_silver_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:raw_lead", "oreganized:raw_lead_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "create:raw_zinc", "create:raw_zinc_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "sullysmod:jade", "sullysmod:jade_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:silver_ingot", "oreganized:silver_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "oreganized:lead_ingot", "oreganized:lead_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "create:zinc_ingot", "create:zinc_block");
        HandheldCompactorItem.addOptional((ImmutableBiMap.Builder<class_1792, class_1792>)builder, "create:brass_ingot", "create:brass_block");
        return builder.build();
    });

    public HandheldCompactorItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(@NotNull class_1799 stack, @Nullable class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.wip_items").method_10862(class_2583.field_24360.method_27706(class_124.field_1061)));
            switch (HandheldCompactorItem.getMode(stack)) {
                case DISABLED: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.inactive").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1079, class_124.field_1056})));
                    break;
                }
                case NUGGETS_TO_INGOTS: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.handheld_compactor_nuggets_to_ingots").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1060, class_124.field_1056})));
                    break;
                }
                case INGOTS_TO_BLOCKS: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.handheld_compactor_ingots_to_blocks").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1078, class_124.field_1056})));
                    break;
                }
                case ALL: {
                    tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.handheld_compactor_all").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1054, class_124.field_1056})));
                }
            }
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)class_310.method_1551().field_1690.field_1832.field_1655.method_1444())) {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.handheld_compactor_1").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.handheld_compactor_2").method_10862(class_2583.field_24360.method_27706(class_124.field_1080)));
            } else {
                tooltip.add((class_2561)TranslationUtils.CROUCH.component());
            }
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player.method_18276() && HandheldCompactorItem.getMode(stack) != CompressionMode.DISABLED) {
            level.method_8396(null, player.method_24515(), class_3417.field_19344, class_3419.field_15245, 1.0f, 2.0f);
            HandheldCompactorItem.setMode(stack, CompressionMode.DISABLED);
        } else {
            HandheldCompactorItem.toggleCompactor(player, stack, level);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public static void toggleCompactor(class_1657 player, class_1799 stack, class_1937 level) {
        if (!player.field_6002.field_9236 && stack.method_7909() instanceof HandheldCompactorItem) {
            CompressionMode getMode = HandheldCompactorItem.getMode(stack);
            HandheldCompactorItem.setMode(stack, CompressionMode.VALUES[(getMode.ordinal() + 1) % CompressionMode.VALUES.length]);
            boolean deactivate = getMode == CompressionMode.ALL;
            class_3414 beaconSound = deactivate ? class_3417.field_19344 : class_3417.field_14703;
            level.method_8396(null, player.method_24515(), beaconSound, class_3419.field_15245, 1.0f, 2.0f);
        }
    }

    public boolean method_7886(class_1799 stack) {
        return HandheldCompactorItem.getMode(stack) != CompressionMode.DISABLED;
    }

    public void method_7888(@NotNull class_1799 stack, @NotNull class_1937 level, class_1297 entity, int slotId, boolean isSelected) {
        CompressionMode mode = HandheldCompactorItem.getMode(stack);
        if (entity.method_7325() || mode == CompressionMode.DISABLED || !(entity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)entity;
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 foundItem = inventory.method_5438(i);
            if (foundItem.method_7947() < 9) continue;
            HandheldCompactorItem.doCompacting(HandheldCompactorItem.getCompressedNugget(foundItem), foundItem, player, mode, CompressionMode.NUGGETS_TO_INGOTS);
            HandheldCompactorItem.doCompacting(HandheldCompactorItem.getCompressedIngot(foundItem), foundItem, player, mode, CompressionMode.INGOTS_TO_BLOCKS);
        }
    }

    private static void doCompacting(Optional<class_1799> compressionType, class_1799 sourceItem, class_1657 player, CompressionMode currentMode, CompressionMode targetMode) {
        if (compressionType.isEmpty() || currentMode != targetMode && currentMode != CompressionMode.ALL) {
            return;
        }
        class_1799 newStack = compressionType.get();
        if (!player.method_31548().method_7394(newStack)) {
            player.method_7328(newStack, false);
        }
        sourceItem.method_7934(9);
    }

    public static void addOptional(ImmutableBiMap.Builder<class_1792, class_1792> map, String moddedId, String moddedId2) {
        Optional o1 = class_7923.field_41178.method_17966(new class_2960(moddedId));
        Optional o2 = class_7923.field_41178.method_17966(new class_2960(moddedId2));
        if (o1.isPresent() && o2.isPresent()) {
            map.put((Object)((class_1792)o1.get()), (Object)((class_1792)o2.get()));
        }
    }

    public static Optional<class_1799> getCompressedNugget(class_1799 stack) {
        return Optional.ofNullable((class_1792)NUGGET_COMPACTING.get().get((Object)stack.method_7909())).map(item -> item.method_8389().method_7854());
    }

    public static Optional<class_1799> getCompressedIngot(class_1799 stack) {
        return Optional.ofNullable((class_1792)INGOT_COMPACTING.get().get((Object)stack.method_7909())).map(item -> item.method_8389().method_7854());
    }

    private static void setMode(class_1799 stack, CompressionMode mode) {
        stack.method_7948().method_10582("mode", mode.name());
    }

    public static CompressionMode getMode(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (tag.method_10545("mode")) {
            return CompressionMode.valueOf(tag.method_10558("mode").toUpperCase(Locale.ROOT));
        }
        return CompressionMode.DISABLED;
    }

    public static enum CompressionMode {
        DISABLED,
        NUGGETS_TO_INGOTS,
        INGOTS_TO_BLOCKS,
        ALL;

        public static CompressionMode[] VALUES;

        static {
            VALUES = CompressionMode.values();
        }
    }
}

