/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.items;

import com.ordana.spelunkery.configs.ClientConfigs;
import com.ordana.spelunkery.reg.ModBlocks;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class SaltBucketItem
extends class_1792 {
    public SaltBucketItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltip, class_1836 context) {
        if (ClientConfigs.ENABLE_TOOLTIPS.get().booleanValue()) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.spelunkery.salt_bucket_1", (Object[])new Object[]{this.getSaltToPlace(stack)}).method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1068})));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.spelunkery.salt_bucket_2").method_10862(class_2583.field_24360.method_27705(new class_124[]{class_124.field_1080, class_124.field_1056})));
        }
    }

    public void setAmount(class_1799 stack, int amount) {
        stack.method_7948().method_10569("salt", amount);
    }

    public int getAmount(class_1799 stack) {
        return stack.method_7948().method_10550("salt");
    }

    public int getSaltToPlace(class_1799 stack) {
        return switch (this.getAmount(stack)) {
            default -> 8;
            case 1 -> 7;
            case 2 -> 6;
            case 3 -> 5;
            case 4 -> 4;
            case 5 -> 3;
            case 6 -> 2;
            case 7 -> 1;
        };
    }

    public class_1269 method_7884(class_1838 context) {
        class_1269 interactionResult = this.place(new class_1750(context));
        if (!interactionResult.method_23665() && this.method_19263()) {
            class_1269 interactionResult2 = this.method_7836(context.method_8045(), context.method_8036(), context.method_20287()).method_5467();
            return interactionResult2 == class_1269.field_21466 ? class_1269.field_33562 : interactionResult2;
        }
        return interactionResult;
    }

    public class_1269 place(class_1750 context) {
        if (!context.method_7716()) {
            return class_1269.field_5814;
        }
        class_1750 blockPlaceContext = this.updatePlacementContext(context);
        if (blockPlaceContext == null) {
            return class_1269.field_5814;
        }
        class_2680 blockState = this.getPlacementState(blockPlaceContext);
        if (blockState == null) {
            return class_1269.field_5814;
        }
        if (!this.placeBlock(blockPlaceContext, blockState)) {
            return class_1269.field_5814;
        }
        class_2338 blockPos = blockPlaceContext.method_8037();
        class_1937 level = blockPlaceContext.method_8045();
        class_1657 player = blockPlaceContext.method_8036();
        class_1799 itemStack = blockPlaceContext.method_8041();
        class_2680 blockState2 = level.method_8320(blockPos);
        if (blockState2.method_27852(blockState.method_26204())) {
            blockState2 = this.updateBlockStateFromTag(blockPos, level, itemStack, blockState2);
            this.updateCustomBlockEntityTag(blockPos, level, player, itemStack, blockState2);
            blockState2.method_26204().method_9567(level, blockPos, blockState2, (class_1309)player, itemStack);
            if (player instanceof class_3222) {
                class_174.field_1191.method_23889((class_3222)player, blockPos, itemStack);
            }
        }
        class_2498 soundType = blockState2.method_26231();
        level.method_8396(player, blockPos, this.getPlaceSound(blockState2), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
        level.method_43276(class_5712.field_28164, blockPos, class_5712.class_7397.method_43286((class_1297)player, (class_2680)blockState2));
        if (player == null || !player.method_31549().field_7477) {
            if (this.getAmount(itemStack) < 7) {
                this.setAmount(itemStack, this.getAmount(itemStack) + 1);
            } else {
                player.method_6122(context.method_20287(), class_1802.field_8550.method_7854());
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    protected class_3414 getPlaceSound(class_2680 state) {
        return state.method_26231().method_10598();
    }

    @Nullable
    public class_1750 updatePlacementContext(class_1750 context) {
        return context;
    }

    protected boolean updateCustomBlockEntityTag(class_2338 pos, class_1937 level, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        return SaltBucketItem.updateCustomBlockEntityTag(level, player, pos, stack);
    }

    @Nullable
    protected class_2680 getPlacementState(class_1750 context) {
        class_2680 blockState = this.getBlock().method_9605(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    private class_2680 updateBlockStateFromTag(class_2338 pos, class_1937 level, class_1799 stack, class_2680 state) {
        class_2680 blockState = state;
        class_2487 compoundTag = stack.method_7969();
        if (compoundTag != null) {
            class_2487 compoundTag2 = compoundTag.method_10562("BlockStateTag");
            class_2689 stateDefinition = state.method_26204().method_9595();
            for (String string : compoundTag2.method_10541()) {
                class_2769 property = stateDefinition.method_11663(string);
                if (property == null) continue;
                String string2 = compoundTag2.method_10580(string).method_10714();
                blockState = SaltBucketItem.updateState(blockState, property, string2);
            }
        }
        if (blockState != state) {
            level.method_8652(pos, blockState, 2);
        }
        return blockState;
    }

    private static <T extends Comparable<T>> class_2680 updateState(class_2680 state, class_2769<T> property, String valueIdentifier) {
        return property.method_11900(valueIdentifier).map(comparable -> (class_2680)state.method_11657(property, comparable)).orElse(state);
    }

    protected boolean canPlace(class_1750 context, class_2680 state) {
        class_1657 player = context.method_8036();
        class_3726 collisionContext = player == null ? class_3726.method_16194() : class_3726.method_16195((class_1297)player);
        return (!this.mustSurvive() || state.method_26184((class_4538)context.method_8045(), context.method_8037())) && context.method_8045().method_8628(state, context.method_8037(), collisionContext);
    }

    protected boolean mustSurvive() {
        return true;
    }

    protected boolean placeBlock(class_1750 context, class_2680 state) {
        return context.method_8045().method_8652(context.method_8037(), state, 11);
    }

    public static boolean updateCustomBlockEntityTag(class_1937 level, @Nullable class_1657 player, class_2338 pos, class_1799 stack) {
        class_2586 blockEntity;
        MinecraftServer minecraftServer = level.method_8503();
        if (minecraftServer == null) {
            return false;
        }
        class_2487 compoundTag = SaltBucketItem.getBlockEntityData(stack);
        if (compoundTag != null && (blockEntity = level.method_8321(pos)) != null) {
            if (!(level.field_9236 || !blockEntity.method_11011() || player != null && player.method_7338())) {
                return false;
            }
            class_2487 compoundTag2 = blockEntity.method_38244();
            class_2487 compoundTag3 = compoundTag2.method_10553();
            compoundTag2.method_10543(compoundTag);
            if (!compoundTag2.equals((Object)compoundTag3)) {
                blockEntity.method_11014(compoundTag2);
                blockEntity.method_5431();
                return true;
            }
        }
        return false;
    }

    public class_2248 getBlock() {
        return ModBlocks.SALT.get();
    }

    @Nullable
    public static class_2487 getBlockEntityData(class_1799 stack) {
        return stack.method_7941("BlockEntityTag");
    }
}

